;=================================================================
;
;
; setrand(seed);
;
; setrand - set random  # seed
;
_setrand proc far
        push    bp
        mov     bp,sp
        mov     ax,[bp+6]
        or      ax,ax             ; if seed specified
        jnz     setit             ;   use it
        mov     ah,2ch            ; else
        int     21h               ;   use system time (secs &
        mov     ax,dx             ;   1/100's) to get rand seed
setit:
        mov     seed,ax           ; save seed
        mov     word ptr [seed+2],0
        pop     bp
        ret                       ; that's all folks
_setrand endp
;=====================================================================
;
; rand();
;
; rand - fetch a new random number;  at entry, cx=limit
;               at exit, ax=random number
;
;   formula:     rand(i+1)=214013*rand(i)+2531011
;
_rand proc far
        push    bp
        mov     bp,sp
        push    di
        mov     di,[seed+2]
        or      di,di           ; zero?
        mov     ax,3
        mov     bx,43fdh
        mov     cx,[seed]
        jz      zerodi
        mul     cx
        mov     di,ax
        mov     ax,bx
        mul     word ptr [seed+2]
        add     di,ax
zerodi:
        mov     ax,bx
        mul     cx
        add     dx,di
        add     ax,9ec3h
        adc     dx,26h
        mov     [seed],ax
        mov     [seed+2],dx
        mov     ax,dx
        xor     dx,dx
        mov     cx,[bp+4]
        div     cx
        mov     ax,dx
        pop     di
        pop     bp
        ret
_rand endp
;=============================================================
;
        page
_beepoff  proc far
        in      al,61h
        and     al,0fch
        out     61h,al
        ret
_beepoff endp
;
; BEEPON --- turns beeper on with timer 2 gate to value in AX at entry.
;
_beepon proc far
        cmp     _beepflg,0
        jz      boret
        push    bp
        mov     bp,sp
        mov     al,0b6h
        out     43h,al
        mov     ax,[bp+6]
        out     42h,al
        mov     al,ah
        out     42h,al
        in      al,61h
        or      al,3
        out     61h,al
        pop     bp
boret:
        ret
_beepon endp
;======================================================================
;
        page
;
_iskey proc far
        mov     ah,1
        int     16h
        jnz     iskeyret
        mov     ax,0
iskeyret:
        ret
_iskey endp
;
_key proc far
        mov     ah,0
        int     16h
        ret
_key endp
;======================================================================
        page
;
; take_timer();
;
old1coff        dw      ?
old1cseg        dw      ?
;
_take_timer proc far
        push    bp
        mov     bp,sp
        push    si
        push    di
        mov     ax,351ch         ; get old timer interrupt vector
        push    es
        int     21h
        mov     cs:[old1cseg],es
        mov     cs:[old1coff],bx ; save it
        pop     es
        push    ds
        push    cs
        pop     ds
        lea     dx,timerint
        mov     ax,251ch         ; take it
        int     21h
        pop     ds
        pop     di
        pop     si
        pop     bp
        ret
_take_timer endp
;
; give_timer();
;
_give_timer proc far
        push    bp
        mov     bp,sp
        push    si
        push    di
        push    ds
        mov     ds,cs:[old1cseg]
        mov     dx,cs:[old1coff]
        mov     ax,251ch         ; give it
        int     21h
        pop     ds
        pop     di
        pop     si
        pop     bp
        ret
_give_timer endp
;
; beep_seq(listptr);
;
_beep_seq proc far
        cmp     _beepflg,0
        jz      bsret
        push    bp
        mov     bp,sp
        mov     ax,[bp+6]
        mov     beepptr,ax
        call    beepsub
        pop     bp
        pop     ds
bsret:
        ret
;
; timer interrupt
;
timerint:
        push    es
        push    ds
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    bp
        mov     ax,dgroup
        mov     ds,ax
        inc     _timepass
        mov     ax,beeptime
        or      ax,ax
        jz      texit
        dec     beeptime
        jnz     texit
        call    beepsub
texit:
        pop     bp
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     ds
        pop     es
        jmp     dword ptr cs:old1coff
;
beepsub proc near
        mov     si,beepptr
        cld
        lodsw                    ; get next frequency
        or      ax,ax            ; end of list?
        jnz     freqok           ; jif no
        in      al,61h           ; else turn beeper off
        and     al,0fch
        out     61h,al
        ret
beepsub endp
freqok:
        push    ax
        mov     al,0b6h
        out     43h,al
        pop     ax
        out     42h,al           ; write it to timer 2
        mov     al,ah
        out     42h,al
        in      al,61h
        or      al,3
        out     61h,al
        lodsw                    ; get next duration
        mov     beeptime,ax
        mov     beepptr,si
        ret
_beep_seq endp
;
