;************************************************************************
; Compute SEGMENT:OFFSET pair from a given x,y address                  *
; of a pixel.  We know that there is HBYTES bytes in each               *
; raster and that each byte  contains eight pixels.                     *
; To find offest of pixel x,y we use the following formula              *
;                                                                       *
;       OFFSET = HBYTES * y + x/8                                       *
;                                                                       *
; To compute which bit within byte is to be changed we get              *
; (x mod 8) which is remainder when x is divided by 8.                  *
; Which is same as keeping last three bits of x.  We use                *
; position within a byte to rotate value 80H so that the                *
; single bit matches the position in a byte.                            *
; Recall that bit7 in a byte represents left most pixel.                *
; Thus MASK is computed as follows:                                     *
;                                                                       *
;       MASK = ROTATE 80H TO THE RIGHT BY (X AND 7)                     *
;                                                                       *
; Entry:        BX - X coordinate (pixel)                               *
;               AX - Y coordinate (raster)                              *
; Exit:         CL - Mask (x mod 8)                                     *
;               BX - Absolute offset in display buffer                  *
;************************************************************************
GRAPH_SEG       EQU     0A000H          ;Segment of display buffer

Get_Address     PROC    NEAR

        ; Compute SEGMENT:OFFSET pair from x,y pair

    ; RPT this line limits to only 640 pixel widths
        MOV     CX,HBYTES               ;Fetch bytes per raster

        MUL     CX                      ;Compute offset past y rasters
        MOV     CL,BL                   ;Keep copy of x for later
        SHR     BX,1                    ;Get offset within raster as x mod 8
        SHR     BX,1
        SHR     BX,1
        ADD     BX,AX                   ;Add offsets together and keep in BX
        MOV     AX,GRAPH_SEG            ;Fetch segment and copy it into ES
        MOV     ES,AX

        ; Compute MASK within byte from x coordinate

        AND     CL,07H                  ;Compute which bit in a byte
        MOV     AL,80H                  ;and use it to rotate mask into positio
        ROR     AL,CL
        MOV     CL,AL                   ;Keep mask in CL

        RET
Get_Address     ENDP
