;========================================================================
; PIXEL_SET    set the pixel at given X,Y to the supplied color
;
;
; small model parms
;X              EQU     [BP+4]
;Y              EQU     [BP+6]
;COLOR          EQU     [BP+8]
; large model parms
pX              EQU     [BP+6]
pY              EQU     [BP+8]
pCOLOR          EQU     [BP+10]

        PUBLIC  _Pix_Set

_pix_set      Proc far
        push    bp
        mov     bp,sp
        push    es
        push    bx
        push    si
        push    di
        ;
        ; figure out address of this pixel
        ;
        mov     cx,pX       ;set X coordinate
        mov     bx,pY       ;set Y value
        call    emapxy      ;di = offset
        mov     es,_curr_vid_seg

        mov     dx,GRAPHIC12
        ;
        ; enable set/reset mode
        ; then load reset register
        ;
        mov     al,SETRESET ;set SET/RESET register
        out     dx,al
        inc     dx          ;now data register

        mov     al,pCOLOR   ;what color was requested?
        out     dx,al       ;Set the active (set) bits
                            ; that loaded the color into the SETRESET reg.
        dec     dx          ;now back to control register

        mov     al,ENABLERESET ;defines which planes will be modified
                               ; from the SETRESET register
        out     dx,al       ;
        inc     dx          ;and back to data register

        mov     al,0ffh     ;work with all 4 planes
        out     dx,al       ;0ffh should activate all planes
        dec     dx          ;back to control
        ;
        ; now we are ready to put the color out there
        ;
        ;
        ; build a 1-bit mask for the requested pixel
        ;
        mov     cx,pX       ;get the offset within the scan line
        and     cx,07h      ;mod 8 - give bit within byte
        mov     bl,80h      ;a high bit in bl
        shr     bl,cl       ;slide it down to make the mask
        ;
        ; save the other seven bits that we are not messing with
        ; 0 = old latched data, 1=new processor data
        ;
        mov     al,BIT_MASK_REG; select the mask register
        out     dx,al       ;
        mov     al,bl       ;get the mask we built, use it to set the BIT_MASK_REG
        inc     dx          ;up to data
        out     dx,al       ;out it goes
        dec     dx          ;back to control
        ;
        ; set the pixel to new color
        ; while it looks like we are writing 'al' we really have
        ;  set the registers so that the masked bit will be set from
        ;  the SETREST register, for all planes, and all processor
        ;  data is ignored.
        ;
        mov     al,es:[di]  ;read the old to keep all 8 bits
        mov     es:[di],al  ;now set the new pixel color
        ;
        ; finally, put everything back into a known state
        ;
        mov     al,ENABLERESET
        out     dx,al
        inc     dx
        mov     al,00h       ;clear all planes for SETRESET
                             ; this means all data comes from processor
                             ; write, not the SETREST register
        out     dx,al
        dec     dx           ;back at control

        mov     al,BIT_MASK_REG ;set all planes as active
        out     dx,al
        inc     dx           ;back to data
        mov     al,0ffh      ;all bits in byte active
        out     dx,al
        dec     dx           ;back to control
        ;
        ; restore what we saved at the start
        ;
        pop     di
        pop     si
        pop     bx
        pop     es
        mov     sp,bp
        pop     bp
        ret
_pix_set      endp


;========================================================================
; Read the color value at the specified X,y
;  and return it in AX
;
; small parms
X       EQU     [BP+4]
Y       EQU     [BP+6]

; large parms
pX      EQU     [BP+6]
pY      EQU     [BP+8]

        PUBLIC  _Pix_Read

_pix_read  proc far
        push    bp
        mov     bp,sp
        push    es
        push    di

        ;
        ; figure out address of this pixel
        ;
        mov     cx,pX       ;set X coordinate
        mov     bx,pY       ;set Y value
        call    emapxy      ;di = offset
        ;
        ; build a 1-bit mask for the requested pixel
        ;
        mov     cx,pX       ;get the offset within the scan line
        and     cx,07h      ;mod 8 - give bit within byte
        mov     bl,80h      ;a high bit in bl
        shr     bl,cl       ;slide it down to make the mask

        mov     es,_curr_vid_seg
        ;
        ;set the plane counter in CX so that LOOP can be used
        ;
        mov     cx,4        ;CX will be the plane number 3,2,1,0
                            ; start at 4, decrement value to use in AL
                            ; but allows the use of the LOOP cmd to control
                            ; and branch on CX
        mov     dx,GRAPHIC12; pich controller
        mov     al,READ_PLANE_SEL
        out     dx,al
        inc     dx          ;leave DX pointing to data register

        xor     bh,bh       ;clear the storage for the color

epx_plane:
                            ;These two line dup the end of the READ_PLANE
                            ; macro, but inside of the loop we do not
                            ; need to select the GRAPGIC12 reg again.
        mov     al,cl       ;which plane +1
        dec     al          ;which plane
        out     dx,al       ;select next plane
        shl     bh,1        ;move prior data up a bit

        mov     ah,es:[di]  ;get video byte (8 bits) for plane
        and     ah,bl       ;look at the pixel we want
        jz      pix_0       ;is it a zero
        or      bh,1        ;no-put a one in our result
pix_0:
        loop    epx_plane   ;decrements  CX and branches if not 0

        mov     al,bh       ;all done, return must be in AX
        xor     ah,ah       ;clear top of AX
        ;
        ; reset what we messed with
        ;
        pop     di
        pop     es                      ;Restore registers
        mov     sp,bp
        pop     bp
        ret
_pix_read     ENDP
