;======================================================================
; hardware_check ( )
;
;      sets :
;
      Public  _hardware_check
      assume  cs:_text, ds:dgroup, ss:dgroup, es:dgroup

_hardware_check  proc far
       push    bp
       mov     bp,sp
       ;
       ;   Look for CGA or below
       push    es                  ; look in the equipment bios byte
       xor     ax,ax
       mov     es,ax               ; segmwnt 0
       mov     bl,es:[0487h]       ; byte 487h is equipment
       pop     es
       mov     ax,1                ; preset in case
       test    bl,08h              ; is bit clear for EGA 0=EGA
       jz      SMEgaOrVga          ; yes look at monitor stuff
       mov     _curr_vid_card,CGA  ;
       jmp     SMhwdone

SMEgaOrVga:
       ;
       ;   save away the old mode
       mov     ah,0Fh
       int     10h
       xor     ah,ah
       mov     _prior_vid_mode,ax

       ; bios VGA presence test
       mov     bx,0
       mov     ax,1a00h        ; fetch current mode
       int     10h
       cmp     al,1ah          ; VGA will not change it
       jne     SMNoVga
       ;
       ;   Found VGA
       ;
       mov     _curr_vid_card,VGA
       mov     al,bl           ; bl is monitor type
       jmp     SMFoundVid

SMNoVga:
       mov     _curr_vid_card,EGA
       mov     ah,12h
       mov     bl,10h
       int     10h
       mov     al,5
       or      bh,bh
       jnz    SMFoundVid

       mov     al,3
       cmp     cl,9h
       je      SMFoundVid

       cmp     cl,3
       je      SMFoundVid

       mov     al,4
SMFoundVid:
       xor     ah,ah
       mov     _curr_vid_mon,ax
       ;
       ;       Monitor type set
       ;           0 = None        3=ECD or MS
       ;           4 = Color       5=Monochrome
       ;           7 = VGA Mono    8=VGA Color or MS
SMhwdone:
       mov     _curr_vid_seg,0a000h  ; set video ram segment to EGA
       mov     ax,_curr_vid_card
       pop     bp
       ret
_hardware_check  endp

;======================================================================
; setmode(mode);
;
; SETMODE --- change the display mode
;       at entry:       AL =
;                           10h 640x350 COLOR (ega)
;                           12h 640x480 COLOR (ega)
;       globals set:
;              cur_vid_mode        requested mode
;              pixels_wide         screen width in pixels
;              bytes_per_line      video memory bytes per scan line
;              scan_deep           # of visible scan lines
;              max_scan_deep       # of video memory scan lines
;
;  When setting the mode, anything you pass will be used blindly.
;  If the value is greater than 13h, it is assumed that you went for
;  800x600.  This mode uses the same access methods as the classic
;  EGA/VGA modes.
;

_setmode  proc far
       push    bp
       mov     bp,sp
       ;
       ;   check that the hardware has been checked, if not do it
       cmp     _curr_vid_seg,0
       jne     SMhcdone
       call    _hardware_check
SMhcdone:
       ;
       ;   Now set the desired mode
       ;
       mov     ax,[bp+6]        ; get mode
       mov     ah,0             ; bios int 10 function setmode
       int     10h
       ;
       ;   save away the new mode
       ;
       mov     ah,0Fh
       int     10h               ; what does the system say ??
       xor     ah,ah
       mov     _curr_vid_mode,ax
       cmp     al,13h            ; kludge- >13h is assumed to be
       jg      SM800x600         ;    800x600, same algor. as others
       ;
       ;   assume this is a standard EGA/VGA mode of 640 wide
       ;
       mov     _pixels_wide,640
       mov     _bytes_per_line,80
       mov     _max_scan_deep,819
       cmp     al,10h
       jne     SMnot10
       mov     _scan_deep,350
       jmp     SMallDone
SMnot10:
       cmp     al,12h
       jne     SMnot12
       mov     _scan_deep,480
       jmp     SMallDone
SMnot12:
       mov     _scan_deep,0         ; you set this value
       jmp     SMallDone
SM800x600:
       mov     _pixels_wide,800
       mov     _bytes_per_line,100
       mov     _scan_deep,600
       mov     _max_scan_deep,655
SMAllDone:
       mov     sp,bp
       pop     bp
       ret
_setmode  endp
