;====================================================================
;      input   cx= x position
;              bx= y position
;      width of screen in bytes is in cs:_bytes_per_line
;      output  di= ((y*bytes_per_line)+x/8) = byte position


emapxy proc                ;
       push    ax          ;
       push    cx
       push    dx
       push    ds
       mov     ax,dgroup
       mov     ds,ax
       mov     ax,bx       ;ax = y
       mul     _bytes_per_line ; usually 80
       shr     cx,1
       shr     cx,1
       shr     cx,1
       add     cx,ax       ;cx= (y*80)+x
       mov     di,cx       ;di= (y*80)+x
       pop     ds
       pop     dx
       pop     cx
       pop     ax          ;
       ret                 ;
emapxy endp
