/*$mmod l*/
/*$objs rtgraf*/

#define    INMAIN  1

#include   <stdio.h>
#include   <stdlib.h>
#include   <sys/types.h>
#include   <sys/stat.h>
#include   <ctype.h>
#include   <rtgraf.h>

struct  {
   char * fname;
   char far * image;
   } pcs[] = {
       {"mask.msk" ,NULL},     //  0
       {"town.bmp" ,NULL},     //  1
       {"grass.bmp",NULL},     //  2
       {"hmntn.bmp",NULL},     //  3
       {"lmntn.bmp",NULL},     //  4
       {"swamp.bmp",NULL},     //  5
       {"desert.bmp",NULL},    //  6
       { NULL      ,NULL},     //  7
       { NULL      ,NULL},     //  8
       { NULL      ,NULL},     //  9
       { NULL      ,NULL},     //  10
                               //  A cell has 6 sides, each name tells the
                               //  two side the the river passes thru
                               //          2
                               //       1 /-\ 3
                               //       6 \_/ 4
                               //          5
       {"rvr12.bmp",NULL},     //  11
       {"rvr13.bmp",NULL},     //  12
       {"rvr14.bmp",NULL},     //  13
       {"rvr15.bmp",NULL},     //  14
       {"rvr16.bmp",NULL},     //  15
       {"rvr23.bmp",NULL},     //  16
       {"rvr24.bmp",NULL},     //  17
       {"rvr25.bmp",NULL},     //  18
       {"rvr26.bmp",NULL},     //  19
       {"rvr34.bmp",NULL},     //  20
       {"rvr35.bmp",NULL},     //  21
       {"rvr36.bmp",NULL},     //  22
       {"rvr45.bmp",NULL},     //  23
       {"rvr46.bmp",NULL},     //  24
       {"rvr56.bmp",NULL},     //  25
       };
static int pcs_size = sizeof(pcs) / sizeof(pcs[0]);

#define MROWS  20
#define MCOLS  13
   static int map [MROWS][MCOLS] = {
 {  2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   },
 {     2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3},
 {  2,   2,   2,   2,  24,   2,   2,   3,   4,   2,   6,   6,   3,   },
 {    24,   2,   2,  22,  13,  24,   3,   3,   4,   2,   6,   3,   3},
 { 22,  13,  24,  21,   5,  12,   4,   3,   3,   4,   2,   6,   3,   },
 {     5,  12,  15,   5,   5,   4,   3,   4,   3,   4,   2,   3,   3},
 {  2,   5,  20,  19,   2,   2,   1,   4,   4,   3,   2,   2,   3,   },
 {     5,   5,  12,   5,   2,   4,   4,   4,   4,   4,   2,   3,   3},
 {  2,   5,   5,   5,   2,   2,   2,   4,   4,   4,   2,   3,   3,   },
 {     2,   2,   5,   4,   4,   2,   2,   4,   3,   3,   2,   3,   3},
 {  2,   2,   2,   4,   6,   4,   2,   2,   4,   4,   2,   3,   3,   },
 {     2,   2,   6,   6,   6,   4,   2,   2,   4,   4,   2,   3,   3},
 {  2,   2,   2,   6,   1,   6,   2,   2,   2,   4,   4,   1,   3,   },
 {     2,   2,   6,   6,   6,   4,   2,   2,   4,   4,   4,   3,   3},
 {  2,   2,   2,   6,   6,   6,   2,   2,   2,   3,   3,   3,   3,   },
 {     2,   2,   2,   2,   2,   2,   2,   2,   2,   6,   6,   3,   3},
 {  2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   6,   6,   3,   },
 {     2,   2,   2,   2,   2,   2,   2,   2,   2,   6,   6,   3,   3},
 {  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   6,   3,   3,   },
 {     2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3},
       };


int load_files (void);
/************************************************************************
 * MAIN function                                                        *
 ************************************************************************/

void   main(argc, argv)
int    argc;
char   *argv[];
{
   int  mode = 0x10;
   int i,r,c,px,py;


   //  Pick up video mode

   if (argc>1)  {
       i = (int) strtol(argv[1],NULL,0);
       if (i == 0)  {
           printf ("Video mode <%s> is invalid!\n",argv[1]);
           exit (-1);
           }
       mode = i;
       }

   //  Load images

   load_files();

   //  Set video mode

   if ( (mode==0x10) || (mode == 0x12) || (mode > 0x18))  {
       setmode(mode);  /* what ever is passed */
       }
     else  {
       printf ("Video Mode (%d) look invalid for graphics.\n",mode);
       exit (-1);
       }

   clearscreen (2);
   i=1;
   py = 10;
   for ( r=0;r<MROWS;r++)  {
       px = ((r%2==0)? 5:29);
       for (c=0;c<MCOLS;c++)  {
           egamplot (px,py,pcs[map[r][c]].image,pcs[0].image,0);
           px += (32+16);
           }
       py += 16;
       }

   getchar();
   setmode(0x03);  /* set 80x25 color alphanumerics */
}
int
load_files (void)
  {
   struct stat f_st;
   FILE    *fp;
   int i;

   for (i=0; i< pcs_size; i++)  {
       if (pcs[i].fname == NULL) continue;
       if (stat(pcs[i].fname,&f_st) < 0)  {
           perror (pcs[i].fname);
           exit (-1);
           }
       if((pcs[i].image = (char far *)malloc ((size_t)f_st.st_size+10))==NULL)  {
           puts ("malloc error "); exit (-1);
           }
       fp = fopen (pcs[i].fname,"rb");
       fread (pcs[i].image,(int)f_st.st_size,1,fp);
       fclose (fp);
       }
   return 0;
   }
