/*$mmod l*/
/*$objs rtgraf*/

/*
   Display (Flash) an image file to the screen.

   >flash image-file [mask-file] [video-mode]

*/

#define    INMAIN  1

#include   <stdio.h>
#include   <stdlib.h>
#include   <sys/types.h>
#include   <sys/stat.h>
#include   <ctype.h>
#include   <rtgraf.h>


/************************************************************************
 * MAIN function                           *
 ************************************************************************/

void   main(argc, argv)
int    argc;
char   *argv[];
{
   FILE    *fp;
   char *image,*mask;
   struct stat image_st,mask_st;
   int  mode = 0x10;
   enum {simple,masked}  action;


   if (argc<2)  {
       puts("Can't read minds...yet!  A file name please.");
       exit (-1);
       }
   action = simple;
   switch (argc)  {
       case 4:
           mode = (int)strtol(argv[3], NULL, 0);
           if (mode == 0)  {
               printf ("Video mode <%s> is invalid!\n",argv[3]);
               exit (-1);
               }
           action = masked;
       case 3:
           if (isdigit(argv[2][0]))  {
               mode = (int)strtol(argv[2], NULL, 0);
               if (mode == 0)  {
                   printf ("Video mode <%s> is invalid!\n",argv[3]);
                   exit (-1);
                   }
               action = simple;
               }
            else  {
               if (stat(argv[2],&mask_st) < 0)  {
                   perror (argv[2]);
                   exit (-1);
                   }
               if((mask  = malloc ((size_t)mask_st.st_size+10))==NULL)  {
                   puts ("malloc error mask"); exit (-1);
                   }
               fp = fopen (argv[2],"rb");
               fread (mask,(int)mask_st.st_size,1,fp);
               fclose (fp);
               action = masked;
               }
       case 2:
           if (stat(argv[1],&image_st) < 0)  {
               perror (argv[1]);
               exit (-1);
               }
           if((image = malloc ((size_t)image_st.st_size+10))==NULL)  {
               puts ("malloc error"); exit (-1);
               }
           fp = fopen (argv[1],"rb");
           fread (image,(int)image_st.st_size,1,fp);
           fclose (fp);
           break;

       default: puts ("useage> flash image_fn [mask_fn] [vid_mode]");
           exit (-1);
       }
   printf ("Image size id %u bytes (%ld)\n",
           (size_t)image_st.st_size,
                   image_st.st_size);

   if ( (mode==0x10) || (mode == 0x12) || (mode > 0x18))  {
       setmode(mode);  /* what ever is passed */
       }
     else  {
       printf ("Video Mode (%d) look invalid for graphics.\n",mode);
       exit (-1);
       }

   clearscreen (7);
   if (action == simple)
       egaplot  ( 0,0,image,0);
   else
       egamplot ( 0,0,image,mask,0);

   getchar();
   setmode(0x03);  /* set 80x25 color alphanumerics */
}
