/*===========================================================================*\
||  CPAINT                                                 Rip Toren         ||
||                                                             POB 674       ||
||                                                         Columbia, MD 21045||
||                                                                           ||
||  Translate a file created by Microsoft (Zsoft) PcPaint into binary        ||
||     image files. These files are used by RTGRAF display system.           ||
||                                                                           ||
||  input : argv[1] = file name to process                                   ||
||  output: file with name of argv[1], but extension '.BMP'                  ||
||                                                                           ||
\*===========================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

typedef unsigned char byte;

       /*--------------------------------------------------------------------*\
       |   Structure definition for first 128 bytes of .PCC or .PCX file      |
       \*--------------------------------------------------------------------*/
struct header {
       byte    manuf;             /* manufacturer               */
       byte    version;           /* version number             */
       byte    rllenc;            /* run-length packing turned on       */
       byte    bits_p_pixel;      /* bit per pixel              */
       int     x1,y1,x2,y2;       /* cooridinated to top/left bot/rite  */
       int     horiz_res, vert_res;/* resolution of producing screen     */
       byte    palette[48];       /* beats me ???               */
       byte    vmode;
       byte    planes;            /* number of planes in picture        */
       int     bytes_p_line;      /* packed bytes per scan line         */
       byte    filler [200];
       };

FILE *mppic,*mpres;               /* input and output files         */
FILE *res[4];                     /* a file for each possible plane     */
char buff [512];
char drive[_MAX_DRIVE],
     dir  [_MAX_DIR  ],
     name [_MAX_FNAME],
     ext  [_MAX_EXT  ];

                   /*     0   1    2    3    4    5    6    7    */
static char mask[8]  ={ 0x00,0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe};
                      /* names of potential outputs         */
static char *dfname[] = {"p__1.dat","p__2.dat","p__3.dat","p__4.dat"};
static char null_f[] = "NUL";          /* name for non-used planes           */


int encget (int *pbyt,FILE *fid);


/*---------------------------------------------------------------------------*\
|  **************************** M A I N **********************************    |
\*---------------------------------------------------------------------------*/
int
main (argc,argv)
int argc;
char *argv[];
  {
   struct header mp_hdr;
   unsigned char  c, *fb;
   int i, j, k, chr, rows,max_planes,plane,bytes,bits;
   unsigned int rc;
   long byte_cnt;

   if (argc < 2)  {
       puts ("I can't read minds, how about a file name!");
       exit(1);
       }
   /*------------------------------------------------------------------------*\
   |   open input file                                                        |
   \*------------------------------------------------------------------------*/
   mppic = fopen (argv[1],"rb");
   if (mppic==NULL)  {
       puts ("open failed on pic file ");
       exit (1);
       }
   puts ("Open good");
   _splitpath (argv[1],drive,dir,name,ext);

   /*------------------------------------------------------------------------*\
   |   get and display file header                                            |
   \*------------------------------------------------------------------------*/
   fread ((char*)&mp_hdr, 1, 128, mppic);
   printf ("Manufacturer      = %d\n",(int) mp_hdr.manuf            );
   printf ("Version is        = %d\n",(int) mp_hdr.version          );
   printf ("Run length is     = %d\n",(int) mp_hdr.rllenc           );
   printf ("Bits / pixel      = %d\n",(int) mp_hdr.bits_p_pixel     );
   printf ("Coordinate x1     = %d\n",(int) mp_hdr.x1               );
   printf ("Coordinate y1     = %d\n",(int) mp_hdr.y1               );
   printf ("Coordinate x2     = %d\n",(int) mp_hdr.x2               );
   printf ("Coordinate y2     = %d\n",(int) mp_hdr.y2               );
   printf ("Horizontal res    = %d\n",(int) mp_hdr.horiz_res        );
   printf ("Vertical   res    = %d\n",(int) mp_hdr.vert_res         );
   printf ("Planes            = %d\n",(int) mp_hdr.planes           );
   max_planes                 =       (int) mp_hdr.planes            ;
   printf ("Bytes / line      = %d\n",(int) mp_hdr.bytes_p_line     );

                      /* allocate space for one scan line   */
   fb = malloc ((int)mp_hdr.bytes_p_line);
   if (fb==NULL)  {
       puts("malloc failure");
       exit (-1);
       }

   /*------------------------------------------------------------------------*\
   |   Prime each of the files                                                |
   \*------------------------------------------------------------------------*/
   for (i=0; i<min(4,max_planes); i++)
       {
       res[i] = fopen (dfname[i],"w+b");
       }

   byte_cnt = 0;
                      /* bits per row               */
   bits = (mp_hdr.x2 - mp_hdr.x1) + 1;
                      /* row in image               */
   rows = (mp_hdr.y2 - mp_hdr.y1) + 1;
                      /* number of bytes in row (packed)    */

   for (i=0; i<rows; i++)  {
       for (plane=0; plane < mp_hdr.planes; plane++)  {
           k = bits;
           for (bytes=0; bytes < mp_hdr.bytes_p_line; bytes++)  {
               if (EOF != encget (&chr, mppic))  {
                   byte_cnt ++;
                   c = (unsigned char) chr;
                           /* clear last few bits if not in image*/
                   if (k<8) c &= mask[k];
                   *(fb+bytes) = c;    /* store in save array            */
                           /* indicate a non-blank row       */
                   k -= 8;         /* decrem bit count           */
                   if (k<0 ) k=0;
                   }
               }
           for (j=0;j< mp_hdr.bytes_p_line;j++)
               fputc (*(fb+j),res[plane]);
           }
       }
   printf (" BYTE COUNT       = %ld\n",byte_cnt);
   fclose (mpres);

   for (i=0; i<min(4,(int)mp_hdr.planes); i++) {
       fseek (res[i],0L,0);  //rewind each
       }
   fclose (mppic);
//
//
   strcpy (ext,".bmp");
   _makepath (buff,drive,dir,name,ext);

   if ((mpres=fopen(buff,"wb"))== NULL)  {
       puts ("error on open of result");
       perror ("result file");
       exit (-1);
       }
   fwrite ((char*)&bits, sizeof(int), 1, mpres);
   fwrite ((char*)&rows, sizeof(int), 1, mpres);

   for (i=0; i<min(4,(int)mp_hdr.planes); i++) {
       do  {
           rc = fread (buff,1,512,res[i]);  //get some
           if (rc > 0)  {
               fwrite (buff,1,rc,mpres);
               printf ("wrote %u bytes from plane %d\n",rc,i);
               }
           } while ( rc > 0);
       }
   fclose (mpres);
   puts ("Conversion complete");
   return 0;
   }

/*===========================================================================*\
|| Get the bytes from the file.  If bits 6 & 7 are set, this is a count      ||
|| of repetitions of following byte.                                         ||
||                                                                           ||
\*===========================================================================*/
int
encget (pbyt, fid)
int *pbyt;
FILE *fid;
  {
  static int cnt=0, i;
   if (cnt > 0)  {            /* return the same byte again         */
       cnt --;
       *pbyt = i;
       return (0);
       }

                      /* no more characters             */
   if (EOF== (i=fgetc(fid))) return (EOF);

   if (0xC0 == (0xC0 & i))  {         /* it is a repeat count           */
       cnt = (0x3F & i)-1;
       if (EOF == (i= fgetc(fid))) return (EOF);
       }
   *pbyt = i;                 /* return the byte read           */
   return (0);
   }
