


VFONT(5)                  FILE FORMATS                   VFONT(5)



NAME
     vfont - font formats

SYNOPSIS
     #include <vfont.h>

DESCRIPTION
     The fonts used by the  window  system  and  printer/plotters
     have  the  following  format.  Each font is in a file, which
     contains a header, an array of character description  struc-
     tures, and an array of bytes containing the bit maps for the
     characters.  The header has the following format:

          struct header {
                  short           magic;      /* Magic number VFONT_MAGIC */
                  unsigned short  size;       /* Total # bytes of bitmaps */
                  short           maxx;       /* Maximum horizontal glyph size */
                  short           maxy;       /* Maximum vertical glyph size */
                  short           xtend;      /* (unused) */
          };
          #define VFONT_MAGIC     0436

     _m_a_x_x and _m_a_x_y are intended to be the maximum horizontal  and
     vertical size of any glyph in the font, in raster lines.  (A
     glyph is just a printed representation of a character, in  a
     particular size and font.) The size is the total size of the
     bit maps for the characters in bytes.  The  _x_t_e_n_d  field  is
     not currently used.

     After the header is an array of NUM_DISPATCH structures, one
     for  each of the possible characters in the font.  Each ele-
     ment of the array has the form:

          struct dispatch {
                  unsigned short  addr;       /* &(glyph) - &(start of bitmaps) */
                  short           nbytes;     /* # bytes of glyphs (0 if no glyph) */
                  char            up, down, left, right;  /* Widths from baseline point */
                  short           width;      /* Logical width, used by troff */
          };
          #define NUM_DISPATCH    256

     The nbytes field is nonzero for  characters  which  actually
     exist.   For  such  characters,  the addr field is an offset
     into the bit maps to where the character's bit  map  begins.
     The  up  , down, left, and right fields are offsets from the
     base point of the glyph to the edges of the rectangle  which
     the  bit map represents.  (The imaginary ``base point'' is a
     point which is vertically on the ``base line'' of the  glyph
     (the bottom line of a glyph which does not have a descender)
     and horizontally near the left edge of the glyph; often 3 or
     so  pixels past the left edge.)

     The bit map contains up+down
     rows of data for the character, each of which has left+right
     columns  (bits).   Each  row  is  rounded  up to a number of
     bytes.  The width field represents the logical width of  the
     glyph  in bits, and shows the horizontal displacement to the
     base point of the next glyph.

