/*$mmod l*/
/*$objs rtgraf*/

#include   <stdio.h>
#include   <stdlib.h>
#include   <malloc.h>
#include   <fcntl.h>
#include   <sys/types.h>
#include   <sys/stat.h>
#include   <math.h>
#include   "rtgraf.h"

 unsigned char far *font;
 int load_font (char * font_name, char * far *pointer);

 unsigned char save[512];
 unsigned char bmask[512];
 int  pfd;

#define DCOLOR 15

/************************************************************************
 * MAIN function                                                        *
 ************************************************************************/

void   main(argc, argv)
int    argc;
char   *argv[];
{
   int row, i,j, ch;
   int mode = 0x10;
   int last_char;
   char glyph[90];


   if (load_font (argv[1],&font) == -1) exit (-1);

   if (argc>2)  {
       mode = strtol (argv[2],NULL,0);
       if (mode ==0) mode = 0x10;
       }

   setmode(mode);

   sprintf (glyph,"Font = %s",argv[1]);
   row = 5 + font[BASELINE];
   etext (10,row,glyph,DCOLOR,font);

   sprintf (glyph,"Characters 0x%02X thru 0x%02X",
           (unsigned int)font[FIRSTCHAR],(unsigned int)font[LASTCHAR]);
   row += (5 + font[SCANHIGH]);
   etext (10,row,glyph,DCOLOR,font);

   row += (5 + font[SCANHIGH]);
   last_char = (unsigned int )font[LASTCHAR];

   for (ch=0x00; ch <= last_char; ch+=0x20)  {
       for (i=0,j=0; (i<0x20) && (j<pixels_wide);++i,j+=font[PIXWIDE])  {
           glyph[i] = (ch)+i;
           }
       glyph[i] = 0x00;
       etext (1,row,glyph,DCOLOR,font);
       row += (5 + font[SCANHIGH]);
       }
   getchar();
   setmode(0x03);  /* set 80x25 color alphanumerics */
   exit (-1);
}

load_font (char * font_name, char * far *pointer)
  {
   FILE *infnt;
   struct stat fs;
   int rc;

   if ((rc=stat(font_name, &fs))==-1) return -1;
   *pointer = malloc (fs.st_size);
   infnt    = fopen(font_name, "rb");
   fread (*pointer, fs.st_size,1,infnt);
   fclose (infnt);
   puts ("Font loaded");
   return 0;

   }
