/*
   convert a font in 'vfont' format to a BINARY rtgraf font
*/

#include <stdio.h>
#include <stdlib.h>
#include "vfont.h"


   struct header fh;
   struct dispatch fd[NUM_DISPATCH];
   unsigned char *bits;
   unsigned char invert[] = {
   //
   //  If your resulting font looks almost correct, but vertical
   //  strips of tthe characters are backward, then the bits in
   //  your base file are accessed from right to left instead of
   //  left to right (wintin a byte).  This table maps one 8-bit
   //  pattern into its mirror image.
   //
  0,128, 64,192, 32,160, 96,224, 16,144, 80,208, 48,176,112,240,
  8,136, 72,200, 40,168,104,232, 24,152, 88,216, 56,184,120,248,
  4,132, 68,196, 36,164,100,228, 20,148, 84,212, 52,180,116,244,
 12,140, 76,204, 44,172,108,236, 28,156, 92,220, 60,188,124,252,
  2,130, 66,194, 34,162, 98,226, 18,146, 82,210, 50,178,114,242,
 10,138, 74,202, 42,170,106,234, 26,154, 90,218, 58,186,122,250,
  6,134, 70,198, 38,166,102,230, 22,150, 86,214, 54,182,118,246,
 14,142, 78,206, 46,174,110,238, 30,158, 94,222, 62,190,126,254,
  1,129, 65,193, 33,161, 97,225, 17,145, 81,209, 49,177,113,241,
  9,137, 73,201, 41,169,105,233, 25,153, 89,217, 57,185,121,249,
  5,133, 69,197, 37,165,101,229, 21,149, 85,213, 53,181,117,245,
 13,141, 77,205, 45,173,109,237, 29,157, 93,221, 61,189,125,253,
  3,131, 67,195, 35,163, 99,227, 19,147, 83,211, 51,179,115,243,
 11,139, 75,203, 43,171,107,235, 27,155, 91,219, 59,187,123,251,
  7,135, 71,199, 39,167,103,231, 23,151, 87,215, 55,183,119,247,
 15,143, 79,207, 47,175,111,239, 31,159, 95,223, 63,191,127,255,0
         };


main ( int argc, char *argv[] )
  {
   int i, glyph, r,c,xx,first_char,last_char,save_last;
   unsigned char z, Bzero=0;
   FILE * inpt=NULL;
   FILE * outp=NULL;
   int bytes_per_row,rows;
   unsigned char *base;

   if ( argc != 3)  {
       puts (" myfont  infile  outfile");
       exit (-1);
       }
   for (i=1; i< 2/*argc*/; i++)  {
       if ((inpt = fopen (argv[1],"rb"))==NULL)  {
           perror (argv[i]);
           continue;
           }
       if ((outp = fopen (argv[2],"wb"))==NULL)  {
           perror (argv[2]);
           continue;
           }
       fread (&fh,sizeof(fh),1,inpt);
       if (fh.magic != VFONT_MAGIC)  {
           printf ("Invalid magic in %s\n",argv[i]);
           continue;
           }

       printf ("/* %s  max x =%5d  max y =%5d */\n",argv[i],fh.maxx,fh.maxy);
       bits = malloc (fh.size);
       fread ((char*)fd, sizeof (struct dispatch),NUM_DISPATCH,inpt);
       fread (   bits,    1,                       fh.size,     inpt);

       /*
         The bit map contains up+down
         rows of data for the character, each of which has left+right
         columns  (bits).   Each  row  is  rounded  up to a number of
         bytes.  The width field represents the logical width of  the
         glyph  in bits, and shows the horizontal displacement to the
         base point of the next glyph.
       */
       printf ("        %3d,  /* width in bytes */\n",((( fh.maxx-1)/8)+1) );
       z = ((fh.maxx-1)/8)+1 ;
       fwrite (&z,1,1,outp);
       printf ("        %3d,  /* high  in rows  */\n", fh.maxy );
       z = fh.maxy;
       fwrite (&z,1,1,outp);
       printf ("        %3d,  /* baseline       */\n", fd['A'].up);
       z = fd['A'].up;
       fwrite (&z,1,1,outp);
       printf ("        %3d,  /* pixel width    */\n", fh.maxx );
       z = fh.maxx;
       fwrite (&z,1,1,outp);

       for (first_char=0;first_char<32;first_char++)  {
           if (fd[first_char].addr != 0) break;
           }
       printf ("        %3d,  /* first character*/\n", first_char );
       z = first_char;
       fwrite (&z,1,1,outp);

       for (last_char=0;last_char<256;last_char++)  {
           if (fd[last_char].addr != 0) save_last=last_char;
           }
       printf ("        %3d,  /* last  character*/\n\n", save_last);
       z = save_last;
       fwrite (&z,1,1,outp);


       for (glyph=first_char; glyph<=save_last; glyph++)  {
           z = fd[glyph].width;
           fwrite (&z,1,1,outp);

           bytes_per_row = ((fh.maxx-1)/8)+1 ;
           rows          = ((fd[glyph].up + fd[glyph].down));

           if (fd[glyph].addr == 0)  {
               // no glyph for this guy
               for (r=0;r<fh.maxy;r++)  {
                   for (c=0;c<((fh.maxx-1)/8)+1;c++)  {
                       fwrite (&Bzero,1,1,outp);
                       }
                   }
               }
           else  {
               // valid glyph
               xx = 0;
               base = bits + fd[glyph].addr;
               for (r=0;r<rows;r++)  {
                   for (c=0;c<bytes_per_row;  c++) {
/*inverted*/           fwrite (&invert[*(base+(bytes_per_row*r)+c)],1,1,outp);
// not inverted        fwrite (         (base+(bytes_per_row*r)+c) ,1,1,outp);
                       }
                   }
               // incase there wern't MAXY rows in the bitmap
               for ( ;r<fh.maxy;r++)  {
                   for (c=0;c<bytes_per_row;  c++) {
                       fwrite (&Bzero,1,1,outp);
                       }
                   }
               }
           }
       free (bits);
       }
   }
