/*$mmod l*/
/*$objs rtgraf bc4*/

#define    INMAIN  1

#include   <stdio.h>
#include   <stdlib.h>
#include   <conio.h>
#include   <fcntl.h>
#include   <math.h>
#include   <malloc.h>
#include   <memory.h>
#include   <sys/types.h>
#include   <sys/stat.h>
#include   "rtgraf.h"

   int pfd;

   static char pbuff[80];

   unsigned char font1[] = {
               #include "srf_r.16h"
               };
   unsigned char font2[] = {
               #include "pcf_r.14h"
               };
// unsigned char savei[65100];
   #define BIG_FONT font1
   #define SMALL_FONT font2
   #define MSGCOLOR   15

   char title[] = "RTGRAF Function Test Suite";

#define MALL_CHK(_a)  if (_a == NULL) {\
   etext (10,20,"Not enough memory to hold images, continuing.",12,BIG_FONT);\
   etext (10,34,"This must be a small data model.",12,BIG_FONT);\
   return ; };


extern  void uninit(void );
extern  void pause(int secs);
extern  void screen_1(void );
extern  void screen_2(void );
extern  void screen_21(void );
extern  void screen_3(void );
extern  void screen_4(void );
extern  void flower(void );
extern  void main(int argc,char * *argv);
extern  void dbox(int x1,int y1,int x2,int y2,int color);
extern  int size_string(char *str,int *wide,int *deep,unsigned char *font);
extern  int multi_string(int x,int y,char *str,unsigned char *font,int color);

        unsigned long randx;
#define srand(x) (randx=x)
#define rnd(x)  ((((randx=randx*1103515245+12345)>>7)%(x))+1)
#define rndr(x) ((((randx=randx*1103515245+12345)>>7)%(x))  )

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

void uninit(void) {
   setmode(0x03);  /* set 80x25 color alphanumerics */
   }

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#include <time.h>
void
pause (int secs)
  {
   clock_t  start, end;
   start = clock();
   end = start + (secs *CLK_TCK);
   while ((clock() <  end)&&(!kbhit())) ;
   if (kbhit()) getch();
   return;
   }


//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
void
screen_1 (void)
  {
   int     x_off, y_off,x_wid, y_high;
   int     i;
   static char
       msg1[] =  { "This suite will test all of the RTGRAF functions.\n"
                   "Starting with text presentation.\n"
                   "This string starts on each possible bit boundry\n" },
       msg3[] =  { ".=()@#$%abcdefTUVWXYZ12345" };


   clearscreen (2);
   size_string (title,&x_wid,&y_high,BIG_FONT);
   x_off = (pixels_wide - x_wid) / 2;
   y_off = BIG_FONT[SCANHIGH] + BIG_FONT[BASELINE];

   etext (x_off,y_off,title,MSGCOLOR,BIG_FONT);

   size_string (msg1,&x_wid,&y_high,BIG_FONT);
   x_off = (pixels_wide - x_wid) / 2;
   y_off = 3*(BIG_FONT[SCANHIGH]) + BIG_FONT[BASELINE];
   multi_string (x_off,y_off,msg1, BIG_FONT,MSGCOLOR);

   for ( i=0;i<12;i++)  {
       y_off = (7+i)*(BIG_FONT[SCANHIGH]) + BIG_FONT[BASELINE];
       etext (x_off+i, y_off, msg3,0+i,BIG_FONT);
       }
   }

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
void
screen_2 (void)
  {
   int x,y;
   static char
       msg1[] = { "Now we will draw a small box using just\n"
                  "pixel writes in a loop (lot of calls)"} ,
       msg2[] = { "And now using the 'line' function."},
       msg3[] = { "But aligned rectangles are a snap, try this\n"
                  "with 'pixel_set'.\n"}
       ;

   clearscreen (2);

   multi_string (30,40,msg1, SMALL_FONT,MSGCOLOR);
   pause(5);
   for (x=0; x<75; x++)   pix_set (100+x,100,0);
   for (y=0; y<75; y++)   pix_set (100+x,100+y,0);
   for (x=74; x>=0; x--)  pix_set (100+x,100+y,0);
   for (y=74; y>=0; y--)  pix_set (100+x,100+y,0);

   multi_string (30,190,msg2, SMALL_FONT,MSGCOLOR);
   pause(5);
   dbox (200,100,275,175,12);

   multi_string (30,210,msg3, SMALL_FONT,MSGCOLOR);
   pause(5);
   flower ();


   }

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
void
screen_21 (void)
  {
   #define BELOW 120
   int i,x;
   int x1,x2,y1,y2,maxx,maxy;
   static char
       msg1[] = { "Now we will plot points in colors using 'pixel_set' and then read\n"
                  "them back, one at a time.\nDot\nColor" },
       msg2[] = { "As well as points, we can also fill rectangular areas with\n"
                  "color. Here are 150 random examples." },
       msg3[] = { "This checks that the boxes are in fact the size requested.\n"
                  "First draw a box two pixels ouside of the solid rectangle,\n"
                  "then draw the rectangle. There should be a 1 pixel gap\n"
                  "of background color between the two." }
       ;

   static struct bbx {
       int  x1,y1,x2,y2;
       char *msg;
       } bbox []=  {
           {  8, BELOW+110, 15, BELOW+120,"First & last pixels, same byte (8->15)"},
           {  9, BELOW+130, 14, BELOW+140,"Interior pixels, same byte (9->14)"},
           {  8, BELOW+150, 16, BELOW+160,"First pixels, seq. bytes (8->16)"},
           { 10, BELOW+170, 18, BELOW+180,"Middle pixels, seq. bytes (10->18)"},
           { 10, BELOW+190, 26, BELOW+200,"Middle pixels, w/ full byte between (10->26)"},
           };

   static int bbox_size = sizeof(bbox) / sizeof(bbox[0]);
   clearscreen (2);

   // Pixel set and read

   multi_string (30,20,msg1, SMALL_FONT,MSGCOLOR);
   for (i=0;i<16;i++)  {
       pix_set ( 90+i*20, 45, i);
       pix_set ( 91+i*20, 45, i);
       pix_set ( 92+i*20, 45, i);
       pix_set ( 90+i*20, 46, i);
       pix_set ( 91+i*20, 46, i);
       pix_set ( 92+i*20, 46, i);
       x = pix_read (90+i*20,45);
       sprintf (pbuff,"%d",x);
       etext ( 85+i*20, 70, pbuff, 0,SMALL_FONT);
       pause (1);
       }

   multi_string (30,84,msg2, SMALL_FONT,MSGCOLOR);
   pause(5);

   //  Draw a bunch of boxes

   maxx = pixels_wide;
   maxy = scan_deep - BELOW;

   for ( i=0 ; i< 150; i++)  {
       x1 = rnd(maxx);
       x2 = rnd(maxx);
       y1 = rnd(maxy);
       y2 = rnd(maxy);
       if ((x1==x2) || (y1==y2)) continue;
       solid_box (x1,y1+BELOW,x2,y2+BELOW,i);
       }
   pause(3);

   //  Now bounded boxes

   solid_box (0,BELOW,pixels_wide,scan_deep,2);
   multi_string (30,BELOW+30,msg3, SMALL_FONT,MSGCOLOR);
   pause (6);

   for ( i=0; i< bbox_size; i++)  {
       dbox      (bbox[i].x1-2,bbox[i].y1-2,
                  bbox[i].x2+2,bbox[i].y2+2, 0);
       solid_box (bbox[i].x1  ,bbox[i].y1  ,
                  bbox[i].x2  ,bbox[i].y2  , 0);
       multi_string (bbox[i].x2+10,bbox[i].y2,bbox[i].msg, SMALL_FONT,MSGCOLOR);
       }
   }

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
void
screen_3 (void)
  {
  #define BASE_IMAGE  "unicorn.bmp"
  #define BASE_MASK   "unicorn.msk"

   FILE * inpt;
   static char
       msg1[] = { "Now we will draw a graphic image.\n"
                  "There will be two related images.\n"
                  "The first is a colored image within\n"
                  "a full rectangle.  This is a converted\n"
                  "PC Painbrush file.  The second is the\n"
                  "same image with a mask applied so that\n"
                  "only part of the image is shown.\n"} ,
       msg2[] = { "Unfortunately, the image files are not\n"
                  "in this directory!!  NEXT !!\n"},
       msg3[] = { "Please note the light green background\n"
                  "in the area of the neck and mouth.\n"},
       msg4[] = { "When I made up the mask, I missed that\n"
                  "area, so it was drawn from the original\n"
                  "image.\n"}
       ;

   char * image, * mask;
   int  wide, high;
   struct stat file_st;


   clearscreen (2);
   multi_string (290,40,msg1, SMALL_FONT,MSGCOLOR);
   if (stat(BASE_IMAGE,&file_st) != 0)  {
       multi_string (290,300,msg2, SMALL_FONT,12);
       pause(5);
       return;
       }
   image = malloc ((size_t)file_st.st_size+10);
   MALL_CHK(image);
   inpt = fopen (BASE_IMAGE,"rb");
   fread (image,(int)file_st.st_size,1,inpt);
   fclose (inpt);
   wide=*((int*)image);
   high=*((int*)image+1);

   if (stat(BASE_MASK,&file_st) != 0)  {
       multi_string (290,300,msg2, SMALL_FONT,12);
       pause(5);
       return;
       }
   mask  = malloc ((size_t)file_st.st_size+10);
   MALL_CHK(mask);
   inpt = fopen (BASE_MASK ,"rb");
   fread (mask,(int)file_st.st_size,1,inpt);
   fclose (inpt);

   pause (7);

   egaplot  ( 0,0,image,0);
   multi_string (290,160,msg3, SMALL_FONT,MSGCOLOR);
   pause(7);
   solid_box ( 0,0,wide,high,2);
   egamplot ( 0,0,image,mask,0);
   multi_string (290,200,msg4, SMALL_FONT,MSGCOLOR);
   free (image);
   free (mask);
   return;
   }
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
void
screen_4 (void)
  {
   static char
       msg1[] = { "This is complex enough screen to\n"
                  "play with reading an image and then\n"
                  "putting it back.  I will draw 50 random\n"
                  "rectangles, after first saving the screen\n"
                  "image beneath, then restore the image from\n"
                  "the saved image.\n"}
       ;

   char * savei;
   int  i;
   long wide, high, topLx, topLy ,size;
   unsigned int saved_bytes;
   size_t max_save;

   max_save = 65100u;
   savei = malloc (max_save);
   MALL_CHK(savei);

   solid_box ( 289,0,pixels_wide,scan_deep,2);
   multi_string (290,40,msg1, SMALL_FONT,MSGCOLOR);
   pause (7);
   for ( i=0; i< 50; i++)  {
       topLx= rand()%(pixels_wide /2);
       topLy= rand()%(scan_deep/2);
       wide = rand()%(pixels_wide /2);
       high = rand()%(scan_deep/2);
       size = ((((wide-1)/8)+1) * high * 4)+(2*sizeof(int));
       if (size > 64000) continue;
       // if either dimension is zero, eread will save nothing
       // except the dimensions, and egaplot will draw nothing.
       // But 0 would create valid dimensions for rectangles,
       // so this case is skipped entirely.
       if (wide*high == 0) continue;
       eread     (topLx ,topLy, wide, high, savei);
       solid_box (topLx ,topLy, topLx+wide-1, topLy+high-1 ,(rand()%16));
       egaplot   (topLx ,topLy, savei, 0);
       }
   free (savei);
   return;
   }


//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

#define FLOWERCOLOR 13
#define DL1(a,b)  draw_line (midx+tri[a].x, midy-tri[a].y, midx+tri[b].x, midy-tri[b].y, FLOWERCOLOR)
#define DL2(a,b)  draw_line (midx-tri[a].x, midy-tri[a].y, midx-tri[b].x, midy-tri[b].y, FLOWERCOLOR)
#define DL3(a,b)  draw_line (midx+tri[a].x, midy+tri[a].y, midx+tri[b].x, midy+tri[b].y, FLOWERCOLOR)
#define DL4(a,b)  draw_line (midx-tri[a].x, midy+tri[a].y, midx-tri[b].x, midy+tri[b].y, FLOWERCOLOR)
#define DL5(a,b)  draw_line (midx+tri[a].y, midy+tri[a].x, midx+tri[b].y, midy+tri[b].x, FLOWERCOLOR)
#define DL6(a,b)  draw_line (midx+tri[a].y, midy-tri[a].x, midx+tri[b].y, midy-tri[b].x, FLOWERCOLOR)
#define DL7(a,b)  draw_line (midx-tri[a].y, midy+tri[a].x, midx-tri[b].y, midy+tri[b].x, FLOWERCOLOR)
#define DL8(a,b)  draw_line (midx-tri[a].y, midy-tri[a].x, midx-tri[b].y, midy-tri[b].x, FLOWERCOLOR)

#define RES 20

void
flower (void)
  {
   struct point  {
       int  x,y;
       };
   struct point tri[3];
   struct point new[3];
   int  count;
   int  midx, midy;

   clearscreen (2);
   midx = pixels_wide/2;
   midy = scan_deep/2;

   // initial triangle
   tri[0].x = 0;
   tri[0].y = midy;
   tri[1].x = (int)( (float)midy * 0.70711);
   tri[1].y = (int)( (float)midy * 0.70711);
   tri[2].y = 0;
   tri[2].x = 0;

   for ( count=0; count<2*RES; count++)  {
       DL1(0,1);
       DL2(0,1);
       DL3(0,1);
       DL4(0,1);
       DL5(0,1);
       DL6(0,1);
       DL7(0,1);
       DL8(0,1);
       DL1(1,2);
       DL2(1,2);
       DL3(1,2);
       DL4(1,2);
       DL5(1,2);
       DL6(1,2);
       DL7(1,2);
       DL8(1,2);
       DL1(2,0);
       DL2(2,0);
       DL3(2,0);
       DL4(2,0);
       DL5(2,0);
       DL6(2,0);
       DL7(2,0);
       DL8(2,0);

       // figure out the next points
       new[0].x = tri[0].x + ((tri[2].x - tri[0].x) / RES);
       new[0].y = tri[0].y + ((tri[2].y - tri[0].y) / RES);
       new[1].x = tri[1].x + ((tri[0].x - tri[1].x) / RES);
       new[1].y = tri[1].y + ((tri[0].y - tri[1].y) / RES);
       new[2].x = tri[2].x + ((tri[1].x - tri[2].x) / RES);
       new[2].y = tri[2].y + ((tri[1].y - tri[2].y) / RES);
       memcpy ((char*)tri, (char*)new, sizeof(tri));
       }
   }

/************************************************************************
 * MAIN function                                                        *
 ************************************************************************/

void   main(int argc, char **argv)
{
   int i;
   static unsigned int vmode[] = {0x10, 0x12, 0x54};

   onexit ( uninit );

   if (argc >1)  {
       i = (int)strtol (argv[1],NULL,0);
       if(i>18)vmode[2] = i;

       }

   hardware_check();

   if (curr_vid_card <1)  {
       puts ("This program requires an EGA or better!!");
       exit (-1);
       }

   for ( i=0; i<3; i++)  {
       setmode(vmode[i]);
       if (curr_vid_mode != vmode[i])  {
           uninit();
           printf ("Video mode %d (0%02Xh) did not take with this card\n",
                  vmode[i],vmode[i]);
           continue;
           }
       srand(vmode[i]);
       screen_1 ();
       pause(5);
       screen_21 ();
       pause(10);
       screen_2 ();
       pause(5);
       screen_3 ();
       pause(5);
       screen_4 ();
       pause(5);
       }

}

void
  dbox(int x1, int y1, int x2, int y2, int color)
  {
     draw_line(x1, y1, x2, y1, color);
     draw_line(x2, y1, x2, y2, color);
     draw_line(x2, y2, x1, y2, color);
     draw_line(x1, y2, x1, y1, color);
   }


//Wbox(x1, y1, x2, y2, color, rule)
//int    x1, y1, x2, y2, color, rule;
//{
//   char *msave, *malloc();
//   int     size,t1,t2;
//   int     i,j;
//
//
//   t1 = ((x2-x1)+1) ;
//   t2 = ((y2-y1)+1) ;
//   size = ((t1/8)+1) * t2 * 4;
//   msave = malloc (size);
//   eread(x1 ,y1,t2,t1,msave);
//   printf ("t1=%d  t2=%d  size=%d\n",t1,t2,size);
//   getch ();
//   box (x1,y1,x2,y2,15);
//   getch();
//   solid_box (x1+1,y1+1,x2-1,y2-1);
//   getch();
//   getch();
//
//}


/*==================================================================
   compute the size of a multi-string when it is displayed on the screen.
   Display a multi_string.
   A 'multi-string' is made up of ASCII printables, backspaces, and
   newlines.
====================================================================*/

/*===================================================================
   This routine modifies the parameters 'deep' and 'wide' to the
   size of the enclosing rectangle of the multi-string passed.
   If the 'font' is null, the values will in terms of characters
   rather than pixels.
   If the 'font' is non-null, the size of the character cell will be
   for each character. The returned depth will be the total, from the
   top of the 1st line to the bottom of the last.
  ===================================================================*/
int
size_string ( char *str, int *wide, int *deep, unsigned char *font)
  {
   int  lines=0, max_str=0;
   int  str_len =0;
   unsigned char *cp;

   cp = str;
   for ( ;*cp; cp++)  {
       switch (*cp)  {
           case '\n':
                   if (str_len>max_str) max_str = str_len;
                   str_len = 0;
                   lines ++;
                   break;
           case '\b':
                   if ( *(cp+1) != '\n') str_len --;
                   break;
           default  :
                   if (font!= 0x00)  {
                       if ((*cp < font[FIRSTCHAR] ) ||
                           (*cp > font[LASTCHAR]  ))
                           continue;
                       }
                   str_len ++;
           }
       }
   if ( *(cp-1) != '\n')  {
       if (str_len>max_str) max_str = str_len;
       lines ++;
       }
   //
   //  Now we have the rectangle measured in characters
   //
   if ( font == 0x00)  {
       //  No font supplied, return char counts
       *wide = max_str;
       *deep = lines;
       }
   else  {
       //  Convert char countes to pixels based upon the data in font
       *wide = max_str * font[PIXWIDE];
       *deep = lines   * font[SCANHIGH];
       }
   return 0;
   }

/*===================================================================
   Display the multi-string in the supplied font.
  =================================================================*/

int
multi_string (int x, int y,
              char *str,
              unsigned char *font,
              int color)
  {
   char buff[128];
   char *cp, *bp;
   int  start_x, start_y;

   start_x = x;
   start_y = y;
   if (font == 0x00) return -1;

   cp = str;
   bp = buff;

   while (*cp)  {
       switch (*cp)  {
           case '\n':
               *bp = 0x00;
               etext ( start_x, start_y, buff, color, font);
               bp = buff;
            // start_y += font[SCANHIGH];
               start_y += (font[BASELINE] + (font[SCANHIGH]/4));
               break;
           case '\b':
               *bp = 0x00;
               start_x = etext ( start_x, start_y, buff, color, font);
               start_x -= font[PIXWIDE];
               bp = buff;
               break;
           default :
               *bp = *cp;
               bp++;
           }
       cp++;
       }
   if ( *(cp-1) != '\n')  {
       *bp = 0x00;
       etext ( start_x, start_y, buff, color, font);
       }
   return 0;
   }

