GRAPHIC12        EQU  3ceh
SETRESET         EQU  0
ENABLERESET      EQU  1
DATA_ROTATE_REG  EQU  3
READ_PLANE_SEL   EQU  4
WRITMODE_REG     EQU  5
BIT_MASK_REG     EQU  8
ENABLESET        EQU  0fh

SEQUENCE_REG     EQU  3c4h
MAP_MASK_REG     EQU  2


GR12_BITMASK    macro  mask
        mov     dx,GRAPHIC12     ; set bit mask to right side
        mov     al,BIT_MASK_REG
        out     dx,al
        inc     dx
        mov     al,mask          ; right end bit mask
        out     dx,al
        endm

SEQ_PLANE       macro  wplane
        mov     dx,SEQUENCE_REG ; enable current plane
        mov     al,MAP_MASK_REG
        out     dx,al
        inc     dx
        mov     al,wplane       ;  set the plane to work with
        out     dx,al
        endm

GR12_FUNCTION   macro  func
        mov     dx,GRAPHIC12
        mov     al,DATA_ROTATE_REG
        out     dx,al           ; set logical operation in ega controller
        inc     dx
        mov     al,func         ; logical function
        out     dx,al
        endm

READ_PLANE      macro  which
        mov     dx,GRAPHIC12    ; set lfbmask
        mov     al,READ_PLANE_SEL
        out     dx,al
        inc     dx
        mov     al,which  ;
        out     dx,al
        endm

GR12_WRITMODE   macro  mode
        mov     dx,GRAPHIC12
        mov     al,WRITMODE_REG
        out     dx,al           ; set logical operation in ega controller
        inc     dx
        mov     al,mode         ; mode 0=direct write
                                ;      1=controller latch write
                                ;      2=bit 'n' to plane 'n' - packed write
                                ;      3=not used
        out     dx,al
        endm
