;========================================================================
; Clear the screen
;
;
; large model parms
pCOLOR          EQU     [BP+6]

        PUBLIC  _clearscreen

_clearscreen  Proc far
        push    bp
        mov     bp,sp
        pushf
        cld
        push    es
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        ;
        ; set up the addressing for the screen
        ;
        mov     es,_curr_vid_seg
        mov     di,0

        mov     dx,GRAPHIC12
        ;
        ; enable set/reset mode
        ; then load reset register
        ;
        mov     al,SETRESET ;set SET/RESET register
        out     dx,al
        inc     dx          ;now data register

        mov     al,pCOLOR   ;what color was requested?
        out     dx,al       ;Set the active (set) bits
                            ; that loaded the color into the SETRESET reg.
        dec     dx          ;now back to control register

        mov     al,ENABLERESET ;defines which planes will be modified
                               ; from the SETRESET register
        out     dx,al       ;
        inc     dx          ;and back to data register

        mov     al,0fh      ;work with all 4 planes from SETRESET register
        out     dx,al       ;0fh should activate all planes
        dec     dx          ;back to control
        ;
        ; now we are ready to put the color out there
        ;
        ;
        ; loop for the size of the screen
        ;
        mov     ax,_max_scan_deep
        mul     _Bytes_per_line
        mov     cx,ax           ; set loop count to size of visual screen
                                ;  in bytes
        mov     al,0fh          ; blend in new color bits
        rep     stosb

        ;
        ; finally, put everything back into a known state
        ;
        mov     dx,GRAPHIC12
        mov     al,ENABLERESET
        out     dx,al
        inc     dx
        mov     al,00h       ;clear all planes for SETRESET
                             ; this means all data comes from processor
                             ; write, not the SETREST register
        out     dx,al
        dec     dx           ;back at control

        mov     al,BIT_MASK_REG ;set all planes as active
        out     dx,al
        inc     dx           ;back to data
        mov     al,0fh       ;all bits in byte active
        out     dx,al
        ;
        ; restore what we saved at the start
        ;
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     es
        popf
        mov     sp,bp
        pop     bp
        ret
_clearscreen  endp
