/*
	rtf.h - RTF document processing stuff.  Release 1.07.
*/


/*
	Twentieths of a point (twips) per inch (Many RTF measurements
	are in twips per inch (tpi) units).  Assumes 72 points/inch.
*/

# define	rtfTpi		1440

/*
	RTF buffer size (avoids BUFSIZ, which differs across systems)
*/

# define	rtfBufSiz	1024

/*
	Tokens are associated with up to three classification numbers:

	Class number: Broadest (least detailed) breakdown.  For programs
		that only care about gross token distinctions.
	Major/minor numbers: Within their class, tokens have a major
		number, and may also have a minor number to further
		distinquish tokens with the same major number.

	*** Class, major and minor token numbers are all >= 0 ***

	Tokens that can't be classified are put in the "unknown" class.
	For such, the major and minor numbers are meaningless, although
	rtfTextBuf may be of interest then.

	Text tokens are a single character, and the major number indicates
	the character value (note: can be non-ascii, i.e., greater than 127).
	There is no minor number.

	Control symbols may have a parameter value, which will be found in
	rtfParam.  If no parameter was given, rtfParam = rtfNoParam.

	RTFGetToken() return value is the class number, but it sets all the
	global token vars.

	rtfEOF is a fake token used by the reader; the writer never sees
	it (except in the token reader hook, if it installs one).
*/


/*
	Information pertaining to last token read by RTFToken.  The
	text is exactly as it occurs in the input file, e.g., "\{"
	will be found in rtfTextBuf as "\{", even though it means "{".
	These variables are also set when styles are reprocessed.
*/

extern char	rtfTextBuf[rtfBufSiz];	/* text of token */
extern int	rtfTextLen;		/* length of token in rtfTextBuf */
extern int	rtfClass;		/* token class */
extern int	rtfMajor;		/* token major number */
extern int	rtfMinor;		/* token minor number */
extern int	rtfParam;		/* control symbol parameter */

# ifdef THINK_C
# define	rtfNoParam	(-32768)	/* 16-bit max. neg. value */
# endif
# ifndef rtfNoParam
# define	rtfNoParam	(-1000000)
# endif

/*
	For some reason, the "Normal" style is numbered 222
*/

# define	rtfNormalStyleNum	222


/*
	Token classes (must be zero-based and sequential)
*/

# define	rtfUnknown	0
# define	rtfGroup	1
# define	rtfText		2
# define	rtfControl	3
# define	rtfEOF		4
# define	rtfMaxClass	5	/* highest class + 1 */

/*
	Group class major numbers
*/

# define	rtfBeginGroup	0
# define	rtfEndGroup	1

/*
	Control class major and minor numbers.
*/

# define	rtfVersion	0

# define	rtfDefFont	1

# define	rtfCharSet	2
# define		rtfAnsiCharSet		0
# define		rtfMacCharSet		1
# define		rtfPcCharSet		2
# define		rtfPcaCharSet		3


/*	destination minor numbers should be zero-based, sequential */

# define	rtfDestination	3
# define		rtfPict			0
# define		rtfNeXTGraphic		1
# define		rtfFootnote		2
# define		rtfHeader		3
# define		rtfHeaderLeft		4
# define		rtfHeaderRight		5
# define		rtfHeaderFirst		6
# define		rtfFooter		7
# define		rtfFooterLeft		8
# define		rtfFooterRight		9
# define		rtfFooterFirst		10
# define		rtfFNSep		11
# define		rtfFNContSep		12
# define		rtfFNContNotice		13
# define		rtfInfo			14
# define		rtfStyleSheet		15
# define		rtfFontTbl		16
# define		rtfColorTbl		17
# define		rtfField		18
# define		rtfFieldInst		19
# define		rtfFieldResult		20
# define		rtfIndex		21
# define		rtfIndexBold		22
# define		rtfIndexItalic		23
# define		rtfIndexText		24
# define		rtfIndexRange		25
# define		rtfTOC			26
# define		rtfBookmarkStart	27
# define		rtfBookmarkEnd		28
# define		rtfITitle		29
# define		rtfISubject		30
# define		rtfIAuthor		31
# define		rtfIOperator		32
# define		rtfIKeywords		33
# define		rtfIComment		34
# define		rtfIVersion		35
# define		rtfIDoccomm		36
# define		rtfIVerscomm		37
# define		rtfKeyCode		38
# define		rtfObject		40
# define		rtfObjClass		41
# define		rtfObjName		42
# define		rtfObjData		43
# define		rtfObjResult		44
# define		rtfObjAlias		45
# define		rtfObjSection		46
# define		rtfMaxDestination	47	/* highest dest + 1 */

# define	rtfFontFamily	4
# define		rtfFFNil		0
# define		rtfFFRoman		1
# define		rtfFFSwiss		2
# define		rtfFFModern		3
# define		rtfFFScript		4
# define		rtfFFDecor		5
# define		rtfFFTech		6

# define	rtfColorName	5
# define		rtfRed			0
# define		rtfGreen		1
# define		rtfBlue			2

# define	rtfSpecialChar	6
# define		rtfCurHeadPage		0
# define		rtfCurFNote		1
# define		rtfCurHeadPict		2	/* valid? */
# define		rtfCurHeadDate		3
# define		rtfCurHeadDateLong	4
# define		rtfCurHeadDateAbbrev	5
# define		rtfCurHeadTime		6
# define		rtfFormula		7
# define		rtfNoBrkSpace		8
# define		rtfNoReqHyphen		9
# define		rtfNoBrkHyphen		10
# define		rtfPage			11
# define		rtfLine			12
# define		rtfPar			13
# define		rtfSect			14
# define		rtfTab			15
# define		rtfCell			16
# define		rtfRow			17
# define		rtfCurAnnot		18
# define		rtfAnnotation		19
# define		rtfAnnotID		20
# define		rtfCurAnnotRef		21
# define		rtfFNoteSep		22
# define		rtfFNoteCont		23
# define		rtfColumn		24
# define		rtfOptDest		25
# define		rtfIIntVersion		26
# define		rtfICreateTime		27
# define		rtfIRevisionTime	28
# define		rtfIPrintTime		29
# define		rtfIBackupTime		30
# define		rtfIEditTime		31
# define		rtfIYear		32
# define		rtfIMonth		33
# define		rtfIDay			34
# define		rtfIHour		35
# define		rtfIMinute		36
# define		rtfINPages		37
# define		rtfINWords		38
# define		rtfINChars		39
# define		rtfIIntID		40
# define		rtfBullet		41
# define		rtfEmDash		42
# define		rtfEnDash		43
# define		rtfLQuote		44
# define		rtfRQuote		45
# define		rtfLDblQuote		46
# define		rtfRDblQuote		47

# define	rtfStyleAttr	7
# define		rtfBasedOn		0
# define		rtfNext			1

# define	rtfDocAttr	8
# define		rtfPaperWidth		0
# define		rtfPaperHeight		1
# define		rtfLeftMargin		2
# define		rtfRightMargin		3
# define		rtfTopMargin		4
# define		rtfBottomMargin		5
# define		rtfFacingPage		6
# define		rtfGutterWid		7
# define		rtfDefTab		8
# define		rtfWidowCtrl		9
# define		rtfHyphHotZone		10
# define		rtfFNoteEndSect		11
# define		rtfFNoteEndDoc		12
# define		rtfFNoteText		13
# define		rtfFNoteBottom		14
# define		rtfFNoteStart		15
# define		rtfFNoteRestart		16
# define		rtfPageStart		17
# define		rtfLineStart		18
# define		rtfLandscape		19
# define		rtfFracWidth		20
# define		rtfNextFile		21
# define		rtfTemplate		22
# define		rtfMakeBackup		23
# define		rtfRTFDefault		24
# define		rtfRevisions		25
# define		rtfMirrorMargin		26
# define		rtfRevDisplay		27
# define		rtfRevBar		28
# define		rtfPSOverlay		29
# define		rtfDefLanguage		30

# define	rtfSectAttr	9
# define		rtfSectDef		0
# define		rtfNoBreak		1
# define		rtfColBreak		2
# define		rtfPageBreak		3
# define		rtfEvenBreak		4
# define		rtfOddBreak		5
# define		rtfPageStarts		6
# define		rtfPageCont		7
# define		rtfPageRestart		8
# define		rtfPageDecimal		9
# define		rtfPageURoman		10
# define		rtfPageLRoman		11
# define		rtfPageULetter		12
# define		rtfPageLLetter		13
# define		rtfPageNumLeft		14
# define		rtfPageNumTop		15
# define		rtfHeaderY		16
# define		rtfFooterY		17
# define		rtfLineModulus		18
# define		rtfLineDist		19
# define		rtfLineStarts		20
# define		rtfLineRestart		21
# define		rtfLineRestartPg	22
# define		rtfLineCont		23
# define		rtfTopVAlign		24
# define		rtfBottomVAlign		25
# define		rtfCenterVAlign		26
# define		rtfJustVAlign		27
# define		rtfColumns		28
# define		rtfColumnSpace		29
# define		rtfColumnLine		30
# define		rtfENoteHere		31
# define		rtfTitleSpecial		32
# define		rtfPrtBinFirst		33
# define		rtfPrtBin		34
# define		rtfSectPageWid		35
# define		rtfSectPageHt		36
# define		rtfSectMarginLeft	37
# define		rtfSectMarginRight	38
# define		rtfSectMarginTop	39
# define		rtfSectMarginBottom	40
# define		rtfSectMarginGutter	41
# define		rtfSectLandscape	42

# define	rtfTblAttr	10
# define		rtfCellBordBottom	0
# define		rtfCellBordTop		1
# define		rtfCellBordLeft		2
# define		rtfCellBordRight	3
# define		rtfRowDef		4
# define		rtfRowLeft		5
# define		rtfRowRight		6
# define		rtfRowCenter		7
# define		rtfRowGapH		8
# define		rtfRowHt		9
# define		rtfRowLeftEdge		10
# define		rtfCellPos		11
# define		rtfMergeRngFirst	12
# define		rtfMergePrevious	13
# define		rtfCellShading		14
# define		rtfCellBgPatH		15
# define		rtfCellBgPatV		16
# define		rtfCellFwdDiagBgPat	17
# define		rtfCellBwdDiagBgPat	18
# define		rtfCellHatchBgPat	19
# define		rtfCellDiagHatchBgPat	20
# define		rtfCellDarkBgPatH	21
# define		rtfCellDarkBgPatV	22
# define		rtfCellFwdDarkBgPat	23
# define		rtfCellBwdDarkBgPat	24
# define		rtfCellDarkHatchBgPat	25
# define		rtfCellDarkDiagHatchBgPat 26
# define		rtfCellBgPatLineColor	27
# define		rtfCellBgPatColor	28

# define	rtfParAttr	11
# define		rtfParDef		0
# define		rtfStyleNum		1
# define		rtfInTable		2
# define		rtfKeep			3
# define		rtfKeepNext		4
# define		rtfNoLineNum		5
# define		rtfPBBefore		6
# define		rtfSideBySide		7
# define		rtfQuadLeft		8
# define		rtfQuadRight		9
# define		rtfQuadJust		10
# define		rtfQuadCenter		11
# define		rtfFirstIndent		12
# define		rtfLeftIndent		13
# define		rtfRightIndent		14
# define		rtfSpaceBefore		15
# define		rtfSpaceAfter		16
# define		rtfSpaceBetween		17
# define		rtfTabPos		18
# define		rtfTabRight		19
# define		rtfTabCenter		20
# define		rtfTabDecimal		21
# define		rtfTabBar		22
# define		rtfBorderTop		23
# define		rtfBorderBottom		24
# define		rtfBorderLeft		25
# define		rtfBorderRight		26
# define		rtfBorderBox		27
# define		rtfBorderBar		28
# define		rtfBorderBetween	29
# define		rtfBorderSingle		30
# define		rtfBorderThick		31
# define		rtfBorderShadow		32
# define		rtfBorderDouble		33
# define		rtfBorderDot		34
# define		rtfBorderHair		35
# define		rtfBorderWidth		36
# define		rtfBorderColor		37
# define		rtfBorderSpace		38
# define		rtfLeaderDot		39
# define		rtfLeaderHyphen		40
# define		rtfLeaderUnder		41
# define		rtfLeaderThick		42
# define		rtfLeaderEqual		43
# define		rtfShading		44
# define		rtfBgPatH		45
# define		rtfBgPatV		46
# define		rtfFwdDiagBgPat		47
# define		rtfBwdDiagBgPat		48
# define		rtfHatchBgPat		49
# define		rtfDiagHatchBgPat	50
# define		rtfDarkBgPatH		51
# define		rtfDarkBgPatV		52
# define		rtfFwdDarkBgPat		53
# define		rtfBwdDarkBgPat		54
# define		rtfDarkHatchBgPat	55
# define		rtfDarkDiagHatchBgPat	56
# define		rtfBgPatLineColor	57
# define		rtfBgPatColor		58

# define	rtfCharAttr	12
# define		rtfPlain		0
# define		rtfBold			1
# define		rtfItalic		2
# define		rtfStrikeThru		3
# define		rtfOutline		4
# define		rtfShadow		5
# define		rtfSmallCaps		6
# define		rtfAllCaps		7
# define		rtfInvisible		8
# define		rtfFontNum		9
# define		rtfFontSize		10
# define		rtfExpand		11
# define		rtfUnderline		12
# define		rtfWUnderline		13
# define		rtfDUnderline		14
# define		rtfDbUnderline		15
# define		rtfNoUnderline		16
# define		rtfSuperScript		17
# define		rtfSubScript		18
# define		rtfRevised		19
# define		rtfForeColor		20
# define		rtfBackColor		21
# define		rtfGray			22
# define		rtfLanguage		23
# define		rtfDeleted		24

# define	rtfPictAttr	13
# define		rtfMacQD		0
# define		rtfPMMetafile		1
# define		rtfWinMetafile		2
# define		rtfDevIndBitmap		3
# define		rtfWinBitmap		4
# define		rtfPicWid		5
# define		rtfPicHt		6
# define		rtfPicGoalWid		7
# define		rtfPicGoalHt		8
# define		rtfPicScaleX		9
# define		rtfPicScaleY		10
# define		rtfPicScaled		11
# define		rtfPicCropTop		12
# define		rtfPicCropBottom	13
# define		rtfPicCropLeft		14
# define		rtfPicCropRight		15
# define		rtfPixelBits		16
# define		rtfBitmapPlanes		17
# define		rtfBitmapWid		18
# define		rtfPicBinary		19

# define	rtfBookmarkAttr	14
# define		rtfBookmarkFirstCol	0
# define		rtfBookmarkLastCol	1

# define	rtfNeXTGrAttr	15
# define		rtfNeXTGWidth		0
# define		rtfNeXTGHeight		1

# define	rtfFieldAttr	16
# define		rtfFieldDirty		0
# define		rtfFieldEdited		1
# define		rtfFieldLocked		2
# define		rtfFieldPrivate		3

# define	rtfTOCAttr	17
# define		rtfTOCType		0
# define		rtfTOCLevel		1

# define	rtfPosAttr	18
# define		rtfPosX			0
# define		rtfPosXCenter		1
# define		rtfPosXInside		2
# define		rtfPosXLeft		3
# define		rtfPosXOutSide		4
# define		rtfPosXRight		5
# define		rtfPosY			6
# define		rtfPosYInline		7
# define		rtfPosYTop		8
# define		rtfPosYCenter		9
# define		rtfPosYBottom		10
# define		rtfAbsWid		11
# define		rtfAbsHt		12
# define		rtfTextDistX		13
# define		rtfTextDistY		14
# define		rtfRPosMargV		15
# define		rtfRPosPageV		16
# define		rtfRPosParaV		17
# define		rtfRPosMargH		18
# define		rtfRPosPageH		19
# define		rtfRPosColH		20

# define	rtfObjAttr	19
# define		rtfObjEmb		0
# define		rtfObjLink		1
# define		rtfObjAutoLink		2
# define		rtfObjSubscriber	3
# define		rtfObjICEmb		4
# define		rtfObjLinkSelf		5
# define		rtfObjLock		6
# define		rtfObjHt		7
# define		rtfObjWid		8
# define		rtfObjSetSize		9
# define		rtfObjTransposeY	10
# define		rtfObjCropTop		11
# define		rtfObjCropBottom	12
# define		rtfObjCropLeft		13
# define		rtfObjCropRight		14
# define		rtfObjScaleX		15
# define		rtfObjScaleY		16
# define		rtfObjResRTF		17
# define		rtfObjResPict		18
# define		rtfObjResBitmap		19
# define		rtfObjResText		20
# define		rtfObjResMerge		21
# define		rtfObjBookmarkPubObj	22
# define		rtfObjPubAutoUpdate	23

/*
	\wmetafile argument values
*/

# define	rtfWmMmText		1
# define	rtfWmMmLometric		2
# define	rtfWmMmHimetric		3
# define	rtfWmMmLoenglish	4
# define	rtfWmMmHienglish	5
# define	rtfWmMmTwips		6
# define	rtfWmMmIsotropic	7
# define	rtfWmMmAnisotropic	8

/*
	\pmmetafile argument values
*/

# define	rtfPmPuArbitrary	4
# define	rtfPmPuPels		8
# define	rtfPmPuLometric		12
# define	rtfPmPuHimetric		16
# define	rtfPmPuLoenglish	20
# define	rtfPmPuHienglish	24
# define	rtfPmPuTwips		28

/*
	\lang argument values
*/

# define	rtfLangNoLang			0x0400
# define	rtfLangAlbanian			0x041c
# define	rtfLangArabic			0x0401
# define	rtfLangBahasa			0x0421
# define	rtfLangBelgianDutch		0x0813
# define	rtfLangBelgianFrench		0x080c
# define	rtfLangBrazilianPortuguese	0x0416
# define	rtfLangBulgarian		0x0402
# define	rtfLangCatalan			0x0403
# define	rtfLangLatinCroatoSerbian	0x041a
# define	rtfLangCzech			0x0405
# define	rtfLangDanish			0x0406
# define	rtfLangDutch			0x0413
# define	rtfLangAustralianEnglish	0x0c09
# define	rtfLangUKEnglish		0x0809
# define	rtfLangUSEnglish		0x0409
# define	rtfLangFinnish			0x040b
# define	rtfLangFrench			0x040c
# define	rtfLangCanadianFrench		0x0c0c
# define	rtfLangGerman			0x0407
# define	rtfLangGreek			0x0408
# define	rtfLangHebrew			0x040d
# define	rtfLangHungarian		0x040e
# define	rtfLangIcelandic		0x040f
# define	rtfLangItalian			0x0410
# define	rtfLangJapanese			0x0411
# define	rtfLangKorean			0x0412
# define	rtfLangBokmalNorwegian		0x0414
# define	rtfLangNynorskNorwegian		0x0814
# define	rtfLangPolish			0x0415
# define	rtfLangPortuguese		0x0816
# define	rtfLangRhaetoRomanic		0x0417
# define	rtfLangRomanian			0x0418
# define	rtfLangRussian			0x0419
# define	rtfLangCyrillicSerboCroatian	0x081a
# define	rtfLangSimplifiedChinese	0x0804
# define	rtfLangSlovak			0x041b
# define	rtfLangCastilianSpanish		0x040a
# define	rtfLangMexicanSpanish		0x080a
# define	rtfLangSwedish			0x041d
# define	rtfLangSwissFrench		0x100c
# define	rtfLangSwissGerman		0x0807
# define	rtfLangSwissItalian		0x0810
# define	rtfLangThai			0x041e
# define	rtfLangTraditionalChinese	0x0404
# define	rtfLangTurkish			0x041f
# define	rtfLangUrdu			0x0420

/*
	RTF font, color and style structures.  Used for font table,
	color table, and stylesheet processing.
*/

typedef struct RTFFont		RTFFont;
typedef struct RTFColor		RTFColor;
typedef struct RTFStyle		RTFStyle;
typedef struct RTFStyleElt	RTFStyleElt;


struct RTFFont
{
	char	*rtfFName;		/* font name */
	int	rtfFNum;		/* font number */
	int	rtfFFamily;		/* font family */
	RTFFont	*rtfNextFont;		/* next font in list */
};


/*
	Color values are -1 if the default color for the the color
	number should be used.  The default color is writer-dependent.
*/

struct RTFColor
{
	int		rtfCNum;	/* color number */
	int		rtfCRed;	/* red value */
	int		rtfCGreen;	/* green value */
	int		rtfCBlue;	/* blue value */
	RTFColor	*rtfNextColor;	/* next color in list */
};


struct RTFStyle
{
	char		*rtfSName;	/* style name */
	int		rtfSNum;	/* style number */
	int		rtfSBasedOn;	/* style this one's based on */
	int		rtfSNextPar;	/* style next paragraph style */
	RTFStyleElt	*rtfSSEList;	/* list of style words */
	int		rtfExpanding;	/* non-zero = being expanded */
	RTFStyle	*rtfNextStyle;	/* next style in style list */
};


struct RTFStyleElt
{
	int		rtfSEClass;	/* token class */
	int		rtfSEMajor;	/* token major number */
	int		rtfSEMinor;	/* token minor number */
	int		rtfSEParam;	/* control symbol parameter */
	char		*rtfSEText;	/* text of symbol */
	RTFStyleElt	*rtfNextSE;	/* next element in style */
};


typedef	void (*RTFFuncPtr) ();		/* generic function pointer */


/*
	Public RTF reader routines
*/

extern void		RTFInit ();
extern void		RTFSetStream ();
extern void		RTFSetClassCallback ();
extern RTFFuncPtr	RTFGetClassCallback ();
extern void		RTFSetDestinationCallback ();
extern RTFFuncPtr	RTFGetDestinationCallback ();
extern void		RTFRead ();
extern int		RTFGetToken ();	/* writer should rarely need this */
extern void		RTFUngetToken ();
extern int		RTFPeekToken ();
extern void		RTFSetToken ();
extern void		RTFSetReadHook ();
extern RTFFuncPtr	RTFGetReadHook ();
extern void		RTFRouteToken ();
extern void		RTFSkipGroup ();
extern void		RTFExpandStyle ();
extern int		RTFCheckCM ();
extern int		RTFCheckCMM ();
extern int		RTFCheckMM ();
extern RTFFont		*RTFGetFont ();
extern RTFColor		*RTFGetColor ();
extern RTFStyle		*RTFGetStyle ();
extern char		*RTFAlloc ();
extern char		*RTFStrSave ();
extern void		RTFFree ();
