/*
	rtf2null - RTF-to-nothing translator

	Example only: demonstrates a minimal translator.  Does nothing,
	with the single exception that unknown tokens are echoed.  This
	allows rtf2null to be used as a "find unknown tokens" filter.

	07 Feb 91	Paul DuBois	dubois@primate.wisc.edu

	07 Feb 91 V1.0. Created.
	24 Feb 91 V1.01. Added unknown token class callback.
	14 Jul 93 V1.02. Updated to compile under THINK C 6.0.
*/

# include	<stdio.h>
# ifdef THINK_C
# include	<console.h>
# endif

# include	"rtf.h"

static void UnknownClass ();


int main (argc, argv)
int	argc;
char	**argv;
{

# ifdef	THINK_C
	argc = ccommand (&argv);
# endif /* THINK_C */

	RTFInit ();

	--argc;
	++argv;

	/* not clever; only allows stdin or one named file to be read */

	if (argc > 0)
	{
		if (freopen (argv[0], "r", stdin) == (FILE *) NULL)
		{
			fprintf (stderr, "Can't open \"%s\"\n", argv[0]);
			exit (1);
		}
	}

	RTFSetClassCallback (rtfUnknown, UnknownClass);
	RTFRead ();

	exit (0);
}


/*
	Echo any unknown tokens.  This helps to find out where
	reader needs to be made smarter.
*/

static void UnknownClass ()
{
	fprintf (stderr, "Unknown symbol %s\n", rtfTextBuf);
}
