/*
	rtfskel - skeleton RTF translator

	This provides placeholders for (almost) all the tokens listed in
	rtf.h.  You can use this as a skeleton or framework on which to
	build a new RTF translator.  Plug in your code as you like to
	handle particular tokens, or rip out code for tokens you want to
	ignore.

	The built-in destination readers are left enabled, as is the
	default of style expansion ON.

	07 Feb 91	Paul DuBois	dubois@primate.wisc.edu

	07 Feb 91 V1.0. Created.
	26 Feb 91 V1.01. Updated for distribution 1.05.
	14 Jul 93 V1.02. Updated to compile under THINK C 6.0.  Added
	cases for all the new symbols recognized by distribution
	release 1.07.
*/

# include	<stdio.h>
# ifdef THINK_C
# include	<console.h>
# endif

# include	"rtf.h"


static void	UnknownClass ();
static void	GroupClass ();
static void	TextClass ();
static void	ControlClass ();

static void	Destination ();
static void	CharSet ();
static void	SpecialChar ();
static void	DocAttr ();
static void	SectAttr ();
static void	TblAttr ();
static void	ParAttr ();
static void	CharAttr ();
static void	PictAttr ();
static void	BookmarkAttr ();
static void	NeXTGrAttr ();
static void	FieldAttr ();
static void	TOCAttr ();
static void	PosAttr ();
static void	ObjAttr ();

static void	SelectLanguage();


int main (argc, argv)
int	argc;
char	**argv;
{
# ifdef	THINK_C
	argc = ccommand (&argv);
# endif /* THINK_C */

	RTFInit ();

	--argc;
	++argv;

	/* not clever; only allows stdin or one named file to be read */

	if (argc > 0)
	{
		if (freopen (argv[0], "r", stdin) == NULL)
		{
			fprintf (stderr, "Can't open \"%s\"\n", argv[0]);
			exit (1);
		}
	}

	/* install class callbacks */

	RTFSetClassCallback (rtfUnknown, UnknownClass);
	RTFSetClassCallback (rtfGroup, GroupClass);
	RTFSetClassCallback (rtfText, TextClass);
	RTFSetClassCallback (rtfControl, ControlClass);

	/* process the input stream */

	RTFRead ();

	exit (0);
}


/*
	Token class callbacks
*/


static void UnknownClass ()
{
	/* use this to print warnings about unknown tokens */
}


static void GroupClass ()
{
	switch (rtfMajor)
	{
	case rtfBeginGroup:
		/* push state */
		break;
	case rtfEndGroup:
		/* pop state */
		break;
	}
}

static void TextClass ()
{
	/* rtfMajor contains character value */
}


/*
	Process control symbol.
*/

static void ControlClass ()
{
	switch (rtfMajor)
	{
	case rtfVersion:
		break;
	case rtfDefFont:
		/*
			rtfParam contains the default font number.  Beware
			that there is no guarantee that this font will actually
			be listed in the font table!
		*/
		break;
	case rtfCharSet:
		CharSet ();
		break;
	case rtfDestination:
		Destination ();
		break;
	case rtfFontFamily:
		/* only occurs within font table - can ignore */
		break;
	case rtfColorName:
		/* only occurs within color table - can ignore */
		break;
	case rtfSpecialChar:
		SpecialChar ();
		break;
	case rtfStyleAttr:
		/* only occurs within stylesheet - can ignore */
		break;
	case rtfDocAttr:
		DocAttr ();
		break;
	case rtfSectAttr:
		SectAttr ();
		break;
	case rtfTblAttr:
		TblAttr ();
		break;
	case rtfParAttr:
		ParAttr ();
		break;
	case rtfCharAttr:
		CharAttr ();
		break;
	case rtfPictAttr:
		PictAttr ();
		break;
	case rtfBookmarkAttr:
		BookmarkAttr ();
		break;
	case rtfNeXTGrAttr:
		NeXTGrAttr ();
		break;
	case rtfFieldAttr:
		FieldAttr ();
		break;
	case rtfTOCAttr:
		TOCAttr ();
		break;
	case rtfPosAttr:
		PosAttr ();
		break;
	case rtfObjAttr:
		ObjAttr ();
		break;
	}
}


/*
	Control class major number handlers.  Each one switches on
	the minor numbers that occur within the major number.
*/


static void CharSet ()
{
	switch (rtfMinor)
	{
	case rtfAnsiCharSet:
		break;
	case rtfMacCharSet:
		break;
	case rtfPcCharSet:
		break;
	case rtfPcaCharSet:
		break;
	}
}


static void Destination ()
{
	switch (rtfMinor)
	{
	case rtfPict:
		break;
	case rtfNeXTGraphic:
		break;
	case rtfFootnote:
		break;
	case rtfHeader:
		break;
	case rtfHeaderLeft:
		break;
	case rtfHeaderRight:
		break;
	case rtfHeaderFirst:
		break;
	case rtfFooter:
		break;
	case rtfFooterLeft:
		break;
	case rtfFooterRight:
		break;
	case rtfFooterFirst:
		break;
	case rtfFNSep:
		break;
	case rtfFNContSep:
		break;
	case rtfFNContNotice:
		break;
	case rtfInfo:
		break;
	case rtfStyleSheet:
		/* will never occur because of default destination reader */
		break;
	case rtfFontTbl:
		/* will never occur because of default destination reader */
		break;
	case rtfColorTbl:
		/* will never occur because of default destination reader */
		break;
	case rtfField:
		break;
	case rtfFieldInst:
		break;
	case rtfFieldResult:
		break;
	case rtfIndex:
		break;
	case rtfIndexBold:
		break;
	case rtfIndexItalic:
		break;
	case rtfIndexText:
		break;
	case rtfIndexRange:
		break;
	case rtfTOC:
		break;
	case rtfBookmarkStart:
		break;
	case rtfBookmarkEnd:
		break;
	case rtfITitle:
		break;
	case rtfISubject:
		break;
	case rtfIAuthor:
		break;
	case rtfIOperator:
		break;
	case rtfIKeywords:
		break;
	case rtfIComment:
		break;
	case rtfIVersion:
		break;
	case rtfIDoccomm:
		break;
	case rtfIVerscomm:
		break;
	case rtfKeyCode:
		/*
			Currently will never occur because the stylesheet
			reader eats the keycode group.
		*/
		break;
	case rtfObject:
		break;
	case rtfObjClass:
		break;
	case rtfObjName:
		break;
	case rtfObjData:
		break;
	case rtfObjResult:
		break;
	case rtfObjAlias:
		break;
	case rtfObjSection:
		break;
	}
}


static void SpecialChar ()
{
	switch (rtfMinor)
	{
	case rtfCurHeadPage:
		break;
	case rtfCurFNote:
		break;
	case rtfCurHeadPict:
		break;
	case rtfCurHeadDate:
		break;
	case rtfCurHeadDateLong:
		break;
	case rtfCurHeadDateAbbrev:
		break;
	case rtfCurHeadTime:
		break;
	case rtfFormula:
		break;
	case rtfNoBrkSpace:
		break;
	case rtfNoReqHyphen:
		break;
	case rtfNoBrkHyphen:
		break;
	case rtfPage:
		break;
	case rtfLine:
		break;
	case rtfPar:
		break;
	case rtfSect:
		break;
	case rtfTab:
		break;
	case rtfCell:
		break;
	case rtfRow:
		break;
	case rtfCurAnnot:
		break;
	case rtfAnnotation:
		break;
	case rtfAnnotID:
		break;
	case rtfCurAnnotRef:
		break;
	case rtfFNoteSep:
		break;
	case rtfFNoteCont:
		break;
	case rtfColumn:
		break;
	case rtfOptDest:
		break;
	case rtfIIntVersion:
		break;
	case rtfICreateTime:
		break;
	case rtfIRevisionTime:
		break;
	case rtfIPrintTime:
		break;
	case rtfIBackupTime:
		break;
	case rtfIEditTime:
		break;
	case rtfIYear:
		break;
	case rtfIMonth:
		break;
	case rtfIDay:
		break;
	case rtfIHour:
		break;
	case rtfIMinute:
		break;
	case rtfINPages:
		break;
	case rtfINWords:
		break;
	case rtfINChars:
		break;
	case rtfIIntID:
		break;
	case rtfBullet:
		break;
	case rtfEmDash:
		break;
	case rtfEnDash:
		break;
	case rtfLQuote:
		break;
	case rtfRQuote:
		break;
	case rtfLDblQuote:
		break;
	case rtfRDblQuote:
		break;
	}
}


static void DocAttr ()
{
	switch (rtfMinor)
	{
	case rtfPaperWidth:
		break;
	case rtfPaperHeight:
		break;
	case rtfLeftMargin:
		break;
	case rtfRightMargin:
		break;
	case rtfTopMargin:
		break;
	case rtfBottomMargin:
		break;
	case rtfFacingPage:
		break;
	case rtfGutterWid:
		break;
	case rtfDefTab:
		break;
	case rtfWidowCtrl:
		break;
	case rtfHyphHotZone:
		break;
	case rtfFNoteEndSect:
		break;
	case rtfFNoteEndDoc:
		break;
	case rtfFNoteText:
		break;
	case rtfFNoteBottom:
		break;
	case rtfFNoteStart:
		break;
	case rtfFNoteRestart:
		break;
	case rtfPageStart:
		break;
	case rtfLineStart:
		break;
	case rtfLandscape:
		break;
	case rtfFracWidth:
		break;
	case rtfNextFile:
		break;
	case rtfTemplate:
		break;
	case rtfMakeBackup:
		break;
	case rtfRTFDefault:
		break;
	case rtfRevisions:
		break;
	case rtfMirrorMargin:
		break;
	case rtfRevDisplay:
		break;
	case rtfRevBar:
		break;
	case rtfPSOverlay:
		break;
	case rtfDefLanguage:
		break;
	}
}


static void SectAttr ()
{
	switch (rtfMinor)
	{
	case rtfSectDef:
		break;
	case rtfNoBreak:
		break;
	case rtfColBreak:
		break;
	case rtfPageBreak:
		break;
	case rtfEvenBreak:
		break;
	case rtfOddBreak:
		break;
	case rtfPageStarts:
		break;
	case rtfPageCont:
		break;
	case rtfPageRestart:
		break;
	case rtfPageDecimal:
		break;
	case rtfPageURoman:
		break;
	case rtfPageLRoman:
		break;
	case rtfPageULetter:
		break;
	case rtfPageLLetter:
		break;
	case rtfPageNumLeft:
		break;
	case rtfPageNumTop:
		break;
	case rtfHeaderY:
		break;
	case rtfFooterY:
		break;
	case rtfLineModulus:
		break;
	case rtfLineDist:
		break;
	case rtfLineStarts:
		break;
	case rtfLineRestart:
		break;
	case rtfLineRestartPg:
		break;
	case rtfLineCont:
		break;
	case rtfTopVAlign:
		break;
	case rtfBottomVAlign:
		break;
	case rtfCenterVAlign:
		break;
	case rtfJustVAlign:
		break;
	case rtfColumns:
		break;
	case rtfColumnSpace:
		break;
	case rtfColumnLine:
		break;
	case rtfENoteHere:
		break;
	case rtfTitleSpecial:
		break;
	case rtfPrtBinFirst:
		break;
	case rtfPrtBin:
		break;
	case rtfSectPageWid:
		break;
	case rtfSectPageHt:
		break;
	case rtfSectMarginLeft:
		break;
	case rtfSectMarginRight:
		break;
	case rtfSectMarginTop:
		break;
	case rtfSectMarginBottom:
		break;
	case rtfSectMarginGutter:
		break;
	case rtfSectLandscape:
		break;
	}
}


static void TblAttr ()
{
	switch (rtfMinor)
	{
	case rtfCellBordBottom:
		break;
	case rtfCellBordTop:
		break;
	case rtfCellBordLeft:
		break;
	case rtfCellBordRight:
		break;
	case rtfRowDef:
		break;
	case rtfRowLeft:
		break;
	case rtfRowRight:
		break;
	case rtfRowCenter:
		break;
	case rtfRowGapH:
		break;
	case rtfRowHt:
		break;
	case rtfRowLeftEdge:
		break;
	case rtfCellPos:
		break;
	case rtfMergeRngFirst:
		break;
	case rtfMergePrevious:
		break;
	case rtfCellShading:
		break;
	case rtfCellBgPatH:
		break;
	case rtfCellBgPatV:
		break;
	case rtfCellFwdDiagBgPat:
		break;
	case rtfCellBwdDiagBgPat:
		break;
	case rtfCellHatchBgPat:
		break;
	case rtfCellDiagHatchBgPat:
		break;
	case rtfCellDarkBgPatH:
		break;
	case rtfCellDarkBgPatV:
		break;
	case rtfCellFwdDarkBgPat:
		break;
	case rtfCellBwdDarkBgPat:
		break;
	case rtfCellDarkHatchBgPat:
		break;
	case rtfCellDarkDiagHatchBgPat:
		break;
	case rtfCellBgPatLineColor:
		break;
	case rtfCellBgPatColor:
		break;
	}
}


static void ParAttr ()
{
	switch (rtfMinor)
	{
	case rtfParDef:
		break;
	case rtfStyleNum:
		break;
	case rtfInTable:
		break;
	case rtfKeep:
		break;
	case rtfKeepNext:
		break;
	case rtfNoLineNum:
		break;
	case rtfPBBefore:
		break;
	case rtfSideBySide:
		break;
	case rtfQuadLeft:
		break;
	case rtfQuadRight:
		break;
	case rtfQuadJust:
		break;
	case rtfQuadCenter:
		break;
	case rtfFirstIndent:
		break;
	case rtfLeftIndent:
		break;
	case rtfRightIndent:
		break;
	case rtfSpaceBefore:
		break;
	case rtfSpaceAfter:
		break;
	case rtfSpaceBetween:
		break;
	case rtfTabPos:
		break;
	case rtfTabRight:
		break;
	case rtfTabCenter:
		break;
	case rtfTabDecimal:
		break;
	case rtfTabBar:
		break;
	case rtfBorderTop:
		break;
	case rtfBorderBottom:
		break;
	case rtfBorderLeft:
		break;
	case rtfBorderRight:
		break;
	case rtfBorderBox:
		break;
	case rtfBorderBar:
		break;
	case rtfBorderBetween:
		break;
	case rtfBorderSingle:
		break;
	case rtfBorderThick:
		break;
	case rtfBorderShadow:
		break;
	case rtfBorderDouble:
		break;
	case rtfBorderDot:
		break;
	case rtfBorderHair:
		break;
	case rtfBorderWidth:
		break;
	case rtfBorderColor:
		break;
	case rtfBorderSpace:
		break;
	case rtfLeaderDot:
		break;
	case rtfLeaderHyphen:
		break;
	case rtfLeaderUnder:
		break;
	case rtfLeaderThick:
		break;
	case rtfLeaderEqual:
		break;
	case rtfShading:
		break;
	case rtfBgPatH:
		break;
	case rtfBgPatV:
		break;
	case rtfFwdDiagBgPat:
		break;
	case rtfBwdDiagBgPat:
		break;
	case rtfHatchBgPat:
		break;
	case rtfDiagHatchBgPat:
		break;
	case rtfDarkBgPatH:
		break;
	case rtfDarkBgPatV:
		break;
	case rtfFwdDarkBgPat:
		break;
	case rtfBwdDarkBgPat:
		break;
	case rtfDarkHatchBgPat:
		break;
	case rtfDarkDiagHatchBgPat:
		break;
	case rtfBgPatLineColor:
		break;
	case rtfBgPatColor:
		break;
	}
}


/*
	Several of the attributes can be turned off with param value
	of zero (e.g., \b vs. \b0), but since the value of rtfParam
	is 0 if no param is given, test the text of the token directly.
*/

static void CharAttr ()
{
int	turnOn = (rtfTextBuf[rtfTextLen-1] != '0');

	switch (rtfMinor)
	{
	case rtfPlain:
		break;
	case rtfBold:
		break;
	case rtfItalic:
		break;
	case rtfStrikeThru:
		break;
	case rtfOutline:
		break;
	case rtfShadow:
		break;
	case rtfSmallCaps:
		break;
	case rtfAllCaps:
		break;
	case rtfInvisible:
		break;
	case rtfFontNum:
		break;
	case rtfFontSize:
		break;
	case rtfExpand:
		break;
	case rtfUnderline:
		break;
	case rtfWUnderline:
		break;
	case rtfDUnderline:
		break;
	case rtfDbUnderline:
		break;
	case rtfNoUnderline:
		break;
	case rtfSuperScript:
		break;
	case rtfSubScript:
		break;
	case rtfRevised:
		break;
	case rtfForeColor:
		break;
	case rtfBackColor:
		break;
	case rtfGray:
		break;
	case rtfLanguage:
		SelectLanguage ();
		break;
	case rtfDeleted:
		break;
	}
}


static void PictAttr ()
{
	switch (rtfMinor)
	{
	case rtfMacQD:
		break;
	case rtfPMMetafile:
		break;
	case rtfWinMetafile:
		break;
	case rtfDevIndBitmap:
		break;
	case rtfWinBitmap:
		break;
	case rtfPicWid:
		break;
	case rtfPicHt:
		break;
	case rtfPicGoalWid:
		break;
	case rtfPicGoalHt:
		break;
	case rtfPicScaleX:
		break;
	case rtfPicScaleY:
		break;
	case rtfPicScaled:
		break;
	case rtfPicCropTop:
		break;
	case rtfPicCropBottom:
		break;
	case rtfPicCropLeft:
		break;
	case rtfPicCropRight:
		break;
	case rtfPixelBits:
		break;
	case rtfBitmapPlanes:
		break;
	case rtfBitmapWid:
		break;
	case rtfPicBinary:
		break;
	}
}


static void BookmarkAttr ()
{
	switch (rtfMinor)
	{
	case rtfBookmarkFirstCol:
		break;
	case rtfBookmarkLastCol:
		break;
	}
}


static void NeXTGrAttr ()
{
	switch (rtfMinor)
	{
	case rtfNeXTGWidth:
		break;
	case rtfNeXTGHeight:
		break;
	}
}


static void FieldAttr ()
{
	switch (rtfMinor)
	{
	case rtfFieldDirty:
		break;
	case rtfFieldEdited:
		break;
	case rtfFieldLocked:
		break;
	case rtfFieldPrivate:
		break;
	}
}


static void TOCAttr ()
{
	switch (rtfMinor)
	{
	case rtfTOCType:
		break;
	case rtfTOCLevel:
		break;
	}
}


static void PosAttr ()
{
	switch (rtfMinor)
	{
	case rtfPosX:
		break;
	case rtfPosXCenter:
		break;
	case rtfPosXInside:
		break;
	case rtfPosXLeft:
		break;
	case rtfPosXOutSide:
		break;
	case rtfPosXRight:
		break;
	case rtfPosY:
		break;
	case rtfPosYInline:
		break;
	case rtfPosYTop:
		break;
	case rtfPosYCenter:
		break;
	case rtfPosYBottom:
		break;
	case rtfAbsWid:
		break;
	case rtfAbsHt:
		break;
	case rtfTextDistX:
		break;
	case rtfTextDistY:
		break;
	case rtfRPosMargV:
		break;
	case rtfRPosPageV:
		break;
	case rtfRPosParaV:
		break;
	case rtfRPosMargH:
		break;
	case rtfRPosPageH:
		break;
	case rtfRPosColH:
		break;
	}
}


static void ObjAttr ()
{
	switch (rtfMinor)
	{
	case rtfObjEmb:
		break;
	case rtfObjLink:
		break;
	case rtfObjAutoLink:
		break;
	case rtfObjSubscriber:
		break;
	case rtfObjICEmb:
		break;
	case rtfObjLinkSelf:
		break;
	case rtfObjLock:
		break;
	case rtfObjHt:
		break;
	case rtfObjWid:
		break;
	case rtfObjSetSize:
		break;
	case rtfObjTransposeY:
		break;
	case rtfObjCropTop:
		break;
	case rtfObjCropBottom:
		break;
	case rtfObjCropLeft:
		break;
	case rtfObjCropRight:
		break;
	case rtfObjScaleX:
		break;
	case rtfObjScaleY:
		break;
	case rtfObjResRTF:
		break;
	case rtfObjResPict:
		break;
	case rtfObjResBitmap:
		break;
	case rtfObjResText:
		break;
	case rtfObjResMerge:
		break;
	case rtfObjBookmarkPubObj:
		break;
	case rtfObjPubAutoUpdate:
		break;
	}
}


static void SelectLanguage ()
{
	switch (rtfParam)
	{
	case rtfLangNoLang:
		break;
	case rtfLangAlbanian:
		break;
	case rtfLangArabic:
		break;
	case rtfLangBahasa:
		break;
	case rtfLangBelgianDutch:
		break;
	case rtfLangBelgianFrench:
		break;
	case rtfLangBrazilianPortuguese:
		break;
	case rtfLangBulgarian:
		break;
	case rtfLangCatalan:
		break;
	case rtfLangLatinCroatoSerbian:
		break;
	case rtfLangCzech:
		break;
	case rtfLangDanish:
		break;
	case rtfLangDutch:
		break;
	case rtfLangAustralianEnglish:
		break;
	case rtfLangUKEnglish:
		break;
	case rtfLangUSEnglish:
		break;
	case rtfLangFinnish:
		break;
	case rtfLangFrench:
		break;
	case rtfLangCanadianFrench:
		break;
	case rtfLangGerman:
		break;
	case rtfLangGreek:
		break;
	case rtfLangHebrew:
		break;
	case rtfLangHungarian:
		break;
	case rtfLangIcelandic:
		break;
	case rtfLangItalian:
		break;
	case rtfLangJapanese:
		break;
	case rtfLangKorean:
		break;
	case rtfLangBokmalNorwegian:
		break;
	case rtfLangNynorskNorwegian:
		break;
	case rtfLangPolish:
		break;
	case rtfLangPortuguese:
		break;
	case rtfLangRhaetoRomanic:
		break;
	case rtfLangRomanian:
		break;
	case rtfLangRussian:
		break;
	case rtfLangCyrillicSerboCroatian:
		break;
	case rtfLangSimplifiedChinese:
		break;
	case rtfLangSlovak:
		break;
	case rtfLangCastilianSpanish:
		break;
	case rtfLangMexicanSpanish:
		break;
	case rtfLangSwedish:
		break;
	case rtfLangSwissFrench:
		break;
	case rtfLangSwissGerman:
		break;
	case rtfLangSwissItalian:
		break;
	case rtfLangThai:
		break;
	case rtfLangTraditionalChinese:
		break;
	case rtfLangTurkish:
		break;
	case rtfLangUrdu:
		break;
	}
}