/*
 * definitions for interrupt routine
 */
volatile unsigned TickCount;	/* counter for ticker interrupt */
void interrupt (*OldTimer) (void);
void interrupt Ticker (void);
void wait (void);

void wait (void)
{
  if (--nwait) {
    tick_count = 1;
    while (tick_count);
    nwait = NWAIT;
  }
}

void interrupt Ticker(void) {
    if (!--TickCount) {		/* if tick counter zero */
				/* then chain to old timer interrupt routine */
	TickCount = ??;
	(*old_timer)();
    }
} /* Ticker */

void set_timer (void) {
    #define CLOCK_FREQ  1193182L
    #define TIMER0      0x40
    #define TIMER_MODE  0x43
    #define SQUARE_WAVE 0x36
    #define HERTZ       60     	/* your hertz value here */
    #define TIMER	0x08	/* timer interrupt number */

  unsigned int divisor;

  divisor = (unsigned) (CLOCK_FREQ / HERTZ);
  OldTimer = getvect(TIMER);		/* save old vector */
  disable ();				/* turn off interrupts when messing */
  outportb (TIMER_MODE,SQUARE_WAVE);	/* around with this stuff */
  outportb (TIMER0,divisor & 0x00ff);   /* least significant byte first */
  outportb (TIMER0,(divisor >> 8) & 0x00ff);
  setvect (TIMER,ticker);		/* set new interrupt vector */
  enable ();                            /* and re-enable interrupts */
} /* set_timer */
