/*
 * SOUNDS.C -- plays "When the Saints Go Marching In" while
 * counting ticks.
 * Demonstration of RTCHDW functions.
 */
#include <conio.h>
#include <dos.h>
#include "rtc.h"

#define ControlReg	0x61		/* 8042 Control Register */
#define CommandReg	0x43		/* timer command register */
#define Channel2	0x42		/* channel 2 data register */

volatile unsigned long TickCount;

int Speaker;

/*
 * saints.h -- "Saints Go Marching In"
 */
struct Note {
    unsigned Frequency;
    unsigned Duration;
};

struct Note Song[] = {
    {4561,  244}, {3620,  244}, {3417,  244}, {3044, 1220},
    {4561,  244}, {3620,  244}, {3417,  244}, {3044, 1220},
    {4561,  244}, {3620,  244}, {3417,  244}, {3044,  488},
    {3620,  488}, {4561,  488}, {3620,  488}, {4063, 1220},
    {3620,  244}, {3620,  244}, {4063,  244}, {4561,  976},
    {3620,  488}, {3044,  488}, {3044,  244}, {3417, 1220},
    {3620,  244}, {3417,  244}, {3044,  488}, {3620,  488},
    {4561,  488}, {4063,  488}, {4561, 1220}, {30000,  1220}, {0xffff, 0}
};

void far Singer (void) {
    static struct Note *SongPtr1 = Song;
    static int NoteCounter = 1;
    static int PlayCounter = 1;

    TickCount++;			/* count ticks for foreground process */

    if (--NoteCounter == 0) {
	if (SongPtr1->Frequency == 0xffff)
	    SongPtr1 = Song;
	NoteCounter = SongPtr1->Duration;
	PlayCounter = NoteCounter - (NoteCounter >> 3);
	outportb (Channel2, SongPtr1->Frequency & 0x7f);
	outportb (Channel2, SongPtr1->Frequency >> 8);
	outportb (ControlReg, Speaker | 3);
	SongPtr1++;
    }
    else if (--PlayCounter == 0)
	outportb (ControlReg, Speaker & 0xfc);
}

void main (void) {
    int ch;

    SetPeriodicInt (6, Singer);
    EnableRTCint (PIE);
    Speaker = inportb (ControlReg);
    outportb (ControlReg, Speaker |= 3);/* enable speaker */
    outportb (CommandReg, 0xb6);	/* setup timer channel 2 */

    cprintf ("\r\n\nPress any key to see tick count\r\n"
	     "Press ESC to exit\r\n\n");
    TimerOn ();

    while (getch () != 0x1b)
	cprintf ("TickCount = %lu\n\r", TickCount);

    TimerOff ();
    ResetRTCint (PIE);

    /* disable the speaker */
    ch = inportb (ControlReg);
    outportb (ControlReg, ch & 0xfc);	/* disable speaker */
} /* main */
