#pragma inline
/*
 * Sound.c -- create weird sounds
 */
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include "rtc.h"

#define ControlReg	0x61		/* 8042 Control Register */
#define CommandReg	0x43		/* timer command register */
#define Channel2	0x42		/* channel 2 data register */

static volatile long TickCount = 0;

void far Sounder (void) {
    asm mov ah,[byte ptr TickCount]
    asm and ah,3
    asm mov dx,ControlReg
    asm in al,dx
    asm and al,11111100b
    asm or al,ah
    asm out dx,al

    TickCount++;			/* count ticks for foreground process */
}

void main (void) {
    unsigned char ch;

    SetPeriodicInt (6, Sounder);
    EnableRTCint (PIE);
/*    Speaker = inportb (ControlReg);
/*    outportb (ControlReg, Speaker |= 3);/* enable speaker */
/*    outportb (CommandReg, 0xb6);	/* setup timer channel 2 */

    cprintf ("\r\n\nPress any key to see tick count\r\n"
	     "Press ESC to exit\r\n\n");
    TimerOn ();

    while (getch () != 0x1b)
	cprintf ("TickCount = %lu\n\r", TickCount);

    TimerOff ();
    ResetRTCint (PIE);

    /* disable the speaker */
    ch = inportb (ControlReg);
    outportb (ControlReg, ch & 0xfc);	/* disable speaker */
} /* main */
