/*
 * DUMPCMOS.C -- dump contents of CMOS RAM
 */

#include <stdio.h>
#include "rtc.h"

void main (void) {
    int x,y,Loc,Data;

    printf ("\n%33s\n\n  ", "CMOS RAM Dump");
    for (x = 0; x < 0x10; x++)
        printf (" %2X", x);
    printf ("\n");
    printf ("--------------------------------------------------\n");
    for (x = 0; x < 4; x++) {
	printf ("%X ", x);
        for (y = 0; y < 0x10; y++) {
	    Loc = (x << 4) + y;
	    Data = ReadCMOS (Loc);
	    printf (" %02X", Data);
        }
        printf ("\n");
    }
    Loc = 0x19;
    printf ("Drive type 0 = %02Xh\n", ReadCMOS (0x19));
    printf ("Drive type 1 = %02Xh\n", ReadCMOS (0x1A));
}
