/*
| rpninst.c
|
| Install new colors into the screens.
| 90/05/24, for v3.0
*/
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#include <conio.h>
#include <string.h>
#include "display.h"
#include "rpnio.h"
#include "dispscrn.h"
#include "helpscrn.h"

#define BUF_LENGTH 4096

#define DIALOG_L (H_RIGHT+6)
#define DIALOG_R (H_RIGHT+6+26)
#define DIALOG_T 16
#define DIALOG_B 25


static int handle;

char foremask = 0x0f;

char fr_buf[FRAME_SIZE];
char h1_buf[HELP_SIZE];
char h2_buf[HELP_SIZE];


static char scrn_choice[] =
	"ͻ\r\n"
	"  rpninst  " __DATE__

			       "  \r\n"
	"                        \r\n"
	"  Press  D (Display),   \r\n"
	"    H (Help),  or  Q    \r\n"
	"   to color a screen    \r\n"
	"        or Quit         \r\n"
	"ͼ\r\n" ;

static char help_colors[] =
	"Ŀ\r\n"
	" Press  F, I, C, T, R,  \r\n"
	"  G, B,  S, Q,  or  O:  \r\n"
	"  Ftns  Info  Captions  \r\n"
	"  Title       Reset     \r\n"
	"  backGround  Border    \r\n"
	"  Save  Quit  OtherScrn \r\n"
	"\r\n" ;

static char frame_colors[] =
	"Ŀ\r\n"
	" Press  N,  F,  E,  R,  \r\n"
	"  G,  B,  S,  or  Q :   \r\n"
	"  Number      Function  \r\n"
	"  Exceptions  Reset     \r\n"
	"  backGround  Border    \r\n"
	"  Save        Quit      \r\n"
	"\r\n" ;

static char savingmsg[] =
	"ͻ\r\n"
	"                        \r\n"
	"                        \r\n"
	"                        \r\n"
	"   S A V I N G . . .    \r\n"
	"                        \r\n"
	"                        \r\n"
	"ͼ\r\n" ;


/***************************************************************************/

int promptfor(char *scrn, int x, int y)
{
    window(DIALOG_L, DIALOG_T, DIALOG_R, DIALOG_B);
    cputs(scrn);
    gotoxy(x, y);
    return getche() ;
}

/***************************************************************************/

int cmp2(char *src, char *tgt, unsigned len)
{
    char *t;
    for (t = tgt + len; *src == *tgt; src += 2, tgt += 2)
	    if (tgt == t)
		return 0;
    return *src - *tgt;		/* lexical "difference" */
}
/***************************************************************************/

long lookfrom(char *target, long start, unsigned len)
{
    long posn;
    int n_read;
    char buf[BUF_LENGTH];
    unsigned bp;

    while (start > 0) {
	if ( 0 > (posn = lseek(handle, start, SEEK_SET)) ) {
	    perror("lookfrom loop");
	    exit(4);
	}
	n_read = read(handle, buf, BUF_LENGTH);
	for (bp = 0; (bp+len) < n_read; ++bp)
	    if (0 == cmp2(buf+bp, target, len))
		return posn + bp;			/* Found it! */

	start -= BUF_LENGTH;
    }

    return -1;						/* No match! */
}
/***************************************************************************/

long location(char *tgt, long start, unsigned size, char *msg)
{
    long pos;
    if ( 0 > (pos = lookfrom(tgt, start, size)) )
	if ( 0 > (pos = lookfrom(tgt, start+BUF_LENGTH/2, size)) ) {
	    fputs(msg, stderr);
	    exit(3);
	}
    return pos;
}
/***************************************************************************/

void scribble(char *f, char *p, char *pend, char color)
{
    for ( ; p < pend; ) {
	*f++ = *p++;
	*f++ = color;
    }
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

char numbers[] = "-98765.43210+e88";
char ftns[]    = "Function-names";
char oops[]    = "Exception Messages";
char blanks[]  = "                  ";

void scribbleframe(char *frame)
{
    scribble(frame + (D_WIDTH<<1)+4,
	     numbers,
	     numbers + strlen(numbers), *(frame+(D_WIDTH<<1)+3));
    scribble(frame + (D_WIDTH<<2)+4,
	     ftns,
	     ftns + strlen(ftns), *(frame+(D_WIDTH<<2)+3));
    scribble(frame + (D_WIDTH<<2)+(D_WIDTH<<1)+4,
	     oops,
	     oops + strlen(oops), *(frame+(D_WIDTH<<2)+(D_WIDTH<<1)+3));
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

void erase(char *frame)
{
    scribble(frame + (D_WIDTH<<1)+4,
	     blanks,
	     blanks + strlen(blanks), *(frame+(D_WIDTH<<1)+1));
    scribble(frame + (D_WIDTH<<2)+4,
	     blanks,
	     blanks + strlen(blanks), *(frame+(D_WIDTH<<2)+1));
    scribble(frame + (D_WIDTH<<2)+(D_WIDTH<<1)+4,
	     blanks,
	     blanks + strlen(blanks), *(frame+(D_WIDTH<<2)+(D_WIDTH<<1)+1));
}
/***************************************************************************/

void bump_bkgnd(char *dest, char *end)
{
    int b;

    for (++dest; dest < end; dest +=2) {
	b = (*dest >> 4) & 0x07;
	if (++b > 0x07)
	    b = 0;
	*dest = (*dest & 0x8f) | (b << 4);
    }
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

void reset(char *dest, char *src, char *end)
{
    for (++dest, ++src; src < end; dest +=2, src +=2)
	*dest = *src;
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

void bump_vals(char *scrn, char *master, char *mastend, int index)
{
    int c;
    for ( ; master <= mastend; scrn += 2, master +=2)
	if ( (*master & foremask) == index ) {
	    c = (*scrn & foremask);
	    if ( ++c > 0x0f )
		    c = 0;
	    *scrn = (*scrn & 0xf0) | c;
	}
}
/***************************************************************************/

int do_frame(void)
{
    int c;
    signed char index;

    do {
	puttext(H_LEFT, H_TOP, H_LEFT+D_WIDTH-1, H_TOP+D_DEPTH-1, fr_buf);
	c = promptfor(frame_colors, 12, 3);

	if ( '\r' == c || 'q' == c || 'Q' == c)
	    return 0;

	else if (c == 's' || c == 'S')
	    return 1;

	else if (c == 'r' || c == 'R')
	    reset(fr_buf, frame, frame+FRAME_SIZE);
	else if (c == 'g' || c == 'G')
	    bump_bkgnd(fr_buf, fr_buf+FRAME_SIZE);
	else {
	    switch (c) {
	    case 'e':  case 'E':
		index = DOOPS;  	break;
	    case 'f':    case 'F':
		index = DFTN;  		break;
	    case 'b':  case 'B':
		index = DBORD;		break;
	    case 'n':    case 'N':
		index = DNUM;		break;
	    default: index = -1;
	    }
	    if (index != -1)
		;
		bump_vals(fr_buf+1, frame+1, frame+FRAME_SIZE, index);
	}
    } while (1);
}
/***************************************************************************/

int do_helps(void)
{
    int c, o = 0;
    char *other[2] = { h1_buf, h2_buf };
    signed char index;

    do {
	puttext(H_LEFT, H_TOP, H_LEFT+H_WIDTH-1, H_TOP+H_DEPTH-1, other[o]);

	c = promptfor(help_colors, 12, 3);

	if ( '\r' == c || 'q' == c || 'Q' == c)
	    return 0;

	else if (c == 's' || c == 'S')
	    return 1;

	else if (c == 'o' || c == 'O')
	    o = !o;
	else if (c == 'r' || c == 'R') {
	    reset(h1_buf, help1, help1+HELP_SIZE);
	    reset(h2_buf, help2, help2+HELP_SIZE);
	} else if (c == 'g' || c == 'G') {
	    bump_bkgnd(h1_buf, h1_buf+HELP_SIZE);
	    bump_bkgnd(h2_buf, h2_buf+HELP_SIZE);
	} else {
	    switch (c) {
	    case 'f':  case 'F':			/* Ftns */
		index = H_TEXT;		break;
	    case 'i':  case 'I':			/* Info */
		index = H_NUM;		break;
	    case 'c':  case 'C':			/* Caption */
		index = H_LABEL;	break;
	    case 't':  case 'T':
		index = H_TITLE;	break;
	    case 'b':  case 'B':
		index = H_BORDER;	break;
	    default: index = -1;
	    }
	    if (index != -1) {
		bump_vals(h1_buf+1, help1+1, help1+HELP_SIZE, index);
		bump_vals(h2_buf+1, help2+1, help2+HELP_SIZE, index);
	    }
	}
    } while (1);
}

/***************************************************************************/

static char orig_scrn[ 2*25*80 ];

void warn_save(void)
{
    textattr((BLACK<<4) | LIGHTRED);
    window(DIALOG_L, DIALOG_T, DIALOG_R, DIALOG_B);
    cputs(savingmsg);
}

/***************************************************************************/

int cdecl main(int argc, char **argv)
{
    char msgfr[] = "Can't find Display !\n";
    char msgh1[] = "Can't find Help 1 !\n";
    char msgh2[] = "Can't find Help 2 !\n";
    char progname[80] = "rpn.exe";
    long frpos, h1pos, h2pos;
    int more = 1;
    long start_posn;
    int x, y;

    puts("searching EXE file...");
    x = wherex(); y = wherey();
    if (argc == 2)
	strncpy(progname, argv[1], 79);
    handle = open(progname, O_RDWR | O_BINARY);
    if (handle < 1) {
	perror( progname );
	return 1;
    }

    if ( 0 > (start_posn = lseek(handle, 0, SEEK_END) - BUF_LENGTH) )
	start_posn = 0;
    frpos = location(frame, start_posn, FRAME_SIZE, msgfr);
    h2pos = location(help2, frpos, HELP_SIZE, msgh2);
    h1pos = location(help1, h2pos, HELP_SIZE, msgh1);
    scribbleframe(frame);
    gettext(1,1,80,25, orig_scrn);
    textattr((BLUE<<4) | WHITE);

    do {
	textattr((BLUE<<4) | WHITE);
	switch ( promptfor(scrn_choice, 12, 7) ) {
	case 'q':  case 'Q':
	    more = 0;
	    break;

	case 'd':  case 'D':
	    lseek(handle, frpos, 0);
	    read(handle, fr_buf, FRAME_SIZE);
	    scribbleframe(fr_buf);
	    if (do_frame()) {
		warn_save();
		erase(fr_buf);
		lseek(handle, frpos, 0);
		write(handle, fr_buf, FRAME_SIZE);
		scribbleframe(fr_buf);
	    }
	    break;

	case 'h':  case 'H':
	    lseek(handle, h1pos, 0);
	    read(handle, h1_buf, HELP_SIZE);
	    lseek(handle, h2pos, 0);
	    read(handle, h2_buf, HELP_SIZE);
	    if ( do_helps()) {
		warn_save();
		lseek(handle, h1pos, 0);
		write(handle, h1_buf, HELP_SIZE);
		lseek(handle, h2pos, 0);
		write(handle, h2_buf, HELP_SIZE);
	    }
	}
	puttext(1,1,80,25, orig_scrn);
    } while (more);

    close(handle);
    puttext(1,1,80,25, orig_scrn);
    window(1,1,80,25);
    gotoxy(x, y);
    puts("rpninst done.");
    return 0;
}
/***************************************************************************/

/*************** DEBUG STUFF ******************************************/

#ifdef DEBUG
#define DBG_CPRINTF(lst)	{ \
    window(DIALOG_L, DIALOG_T, DIALOG_R, DIALOG_B); \
    cprintf lst;             }
#define DBG1_CPRINTF(lst)	{ \
    window(DIALOG_L, DIALOG_T, DIALOG_R, DIALOG_B); \
    cprintf lst;             }
#define DBG_GETCH()	getch();

    DBG_CPRINTF((
	"ͻ\r\n"
	"  border %02x  title %02x   \r\n"
	"   label %02x   text %02x   \r\n"
	"     num %02x             \r\n"
	"                        \r\n"
	"    dnum %02x    ftn %02x   \r\n"
	"         oops %02x        \r\n"
	"ͼ\r\n",
	NBORDER, NTITLE, NLABEL, NTEXT, NNUM, NDNUM, NFTN, NOOPS ));
    DBG_GETCH();


#else
#define DBG_CPRINTF(lst)
#define DBG1_CPRINTF(lst)
#define DBG_GETCH()
#endif
/*************** DEBUG STUFF ******************************************/
