/**
 ** matherr.c
 **
 ** Try to handle math errors semi-gracefully, instead of just crashing.
 **/
#include <math.h>
#include <float.h>	/** for _fpreset() prototype **/
#include "debug.h"
#include "rpn.h"
#include "display.h"	/** for prterr() prototype **/
#include "ftns.h"

int cdecl matherr (struct exception *a)
{
    char *errtype;

    math_error = 1;
    switch (a->type) {
    case DOMAIN:
        errtype = "domain";
        break;
    case SING:
        errtype = "singularity";
        break;
    case OVERFLOW:
        errtype = "overflow";
        break;
    case UNDERFLOW:
        errtype = "underflow";
        break;
    case TLOSS:
        errtype = "significant-loss";
        break;
    default:
        errtype = "Unrecognized!";
        break;
    }
    DBG_FPRINTF((errfile,"matherr: name: %s\ntype: %d, errtype: %s\n"
	    "arg1: %f, arg2: %f, retval: %f\n",
	    a->name, a->type, errtype, a->arg1, a->arg2, a->retval));

    prterr(a->name, errtype);
    a->retval = lastx;
    if (stack_popped)
        push();
    lastx = tmpLX;
    _fpreset();		/** reset the math chip **/
    return 1;
}
