/**
 ** DISPLAY.H
 **
 ** Dimensions & colors for the calculator display window.
 ** For version 2, these two defines become global variables in "rpn.h":
 **	#define TOP       6
 **	#define LEFT      39
 **
 ** For v2.3, these defines become global variables in "rpn.h":
 **	#define D_BKGND   BLACK
 **	#define D_BORDER  LIGHTGRAY
 **	#define D_NUM     YELLOW
 **	#define D_FTN     CYAN
 **
 ** 90.05.11 v3.0
 **/
#ifndef DISPLAY_H
#define DISPLAY_H

void open_display(void);
void close_display(void);
void display(void);
void show_base(int);
void prterr(const char *, const char *);


/**********  defines for Display Window  **********/

#define D_WIDTH   38
#define D_DEPTH    9
#define RIGHT     (LEFT-1 + D_WIDTH)
#define BOTTOM    (TOP-1 + D_DEPTH)
#define MSG_LINE  (TOP+6)

#define S_TOP     (TOP+1)       /** for displaying the Stack **/
#define S_BOTTOM  BOTTOM
#define S_LEFT    (LEFT+1)
#define S_RIGHT   (S_LEFT+20)
#define STK_WIDTH (S_RIGHT - S_LEFT + 1)

#define STK_MARKS 7             /** format space used for exp, dec.pt. **/

#define B_LEFT    (LEFT+28)     /** for displaying the Base **/
#define B_RIGHT   (B_LEFT+3)

#define V_LEFT    (LEFT+33)     /** for displaying the Save state **/
#define V_RIGHT   (LEFT+37)


#define F_TOP     (TOP+3)       /** for displaying the Frame **/
#define F_BOTTOM  MSG_LINE
#define F_LEFT    (LEFT+24)
#define F_RIGHT   RIGHT


#ifdef FRAME_ALLOC
#include "dispscrn.h"
#else
extern char frame[];
#endif

#endif  /* DISPLAY_H */
