/*





                                                                    R E G K E Y

 ------------------------------------------------------------------------------


                                                                   Version 3.10


                                    The Registration Key System For Programmers


                                                              C/C++ Header File




          (C) Copyright Brian Pirie, 1993 - 1994. All Rights Reserved.

*/

#ifndef REGKEY_H
#define REGKEY_H



/* COMPILER-DEPENDANT DEFINITIONS */
/* ------------------------------ */
#ifdef __cplusplus
#define RKFUNCDEF extern "C"
#else
#define RKFUNCDEF
#endif
#ifndef FAR
#define FAR far
#endif
#ifdef __POWERC
#define CONST
#else
#define CONST const
#endif



/* FUNCTION RETURN VALUES */
/* ---------------------- */
typedef enum
   {
   RK_FAILURE,
   RK_SUCCESS
   } RKRETURN;



/* REGISTRATION KEY VALIDATION RESULTS */
/* ----------------------------------- */
typedef enum
   {
   RK_UNREGISTERED,
   RK_REGISTERED
   } RKVALID;



/* FUNCTION PROTOTYPES FOR THE REGKEY API */
/* -------------------------------------- */
#ifndef NOT_C_TARGET

/* RegKeyNewCodeSet()                                                        */
/*                                                                           */
/* Generates a registration key validation code corresponding to a           */
/* generation code. This set of generation and validation codes is unique    */
/* for each application using RegKey, and determines the unique registration */
/* key that corresponds to a particular user's name. The secret generation   */
/* code is used at registration key generation time, and the corresponding   */
/* validation code is used within your application when validating a         */
/* registration key. The validation and generation codes are each            */
/* represented as a ten-digit strings of numbers and upper-case letters.     */
/*                                                                           */
/* This function is called by KeyGen or your own utility, and is only used   */
/* once for each application using RegKey.                                   */

RKFUNCDEF RKRETURN RegKeyNewCodeSet(
   CONST char FAR *szGenerationCode,   /* INPUT: Ten digit generation code   */
   char FAR *szValidationCode);        /* OUTPUT: Ten digit validation code  */


/* RegKeyGenerate()                                                          */
/*                                                                           */
/* Generates a registration key for a particular user, using the secret      */
/* generation code corresponding to a particular application (as passed to   */
/* RegKeyNewCodeSet()). The registration string is usually the name of the   */
/* registered user, but may also contain other information, such as the      */
/* version registered or date of expiry. The registration string may be zero */
/* to 64K characters in length, and is null-terminated. The registration key */
/* is returned as a string of letters and upper-case letters. The string     */
/* pointed to by szRegKey must be large enough to hold 20 digits, plus a     */
/* string terminator character. szRandomSeed should contain 10 random        */
/* numbers and upper-case numbers, which are required during the             */
/* registration key generation process.                                      */
/*                                                                           */
/* This function is called by KeyGen or your own registration key generation */
/* utility, each time a registration key is generated for a new user. This   */
/* function is used for user-entered registration keys; compare with         */
/* RegKeyFileGenerate().                                                     */

RKFUNCDEF RKRETURN RegKeyGenerate(
   CONST char FAR *szRegString,        /*  INPUT: Registration string        */
   CONST char FAR *szGenerationCode,   /*  INPUT: App's generation code      */
   CONST char FAR *szRandomSeed,       /*  INPUT: Random number seed         */
   char FAR *szRegKey);                /* OUTPUT: 20-digit registration key  */


/* RegKeyValidate()                                                          */
/*                                                                           */
/* Checks whether a given registration string and registration key           */
/* combination is valid for a particular application, using the application- */
/* specific validation code that was generated by RegKeyNewCodeSet(). The    */
/* RKVALID pointed to by peRegistered is set to either RK_REGISTERED or      */
/* RK_UNREGISTERED, indicating whether or not the registration key and       */
/* registration string are valid. If you have registered RegKey, your own    */
/* name and RegKey registration key should be passed to this function to     */
/* disable the RegKey "unregistered" message.                                */
/*                                                                           */
/* This function is called from within your application each time it         */
/* executes, in order to determine whether it should operate in registered   */
/* or unregistered mode. This function is used with user-entered             */
/* registration keys; compare with RegKeyFileValidate().                     */

RKFUNCDEF RKRETURN RegKeyValidate(
   CONST char FAR *szRegString,        /*  INPUT: Registration string        */
   CONST char FAR *szRegKey,           /*  INPUT: 20-digit registration key  */
   CONST char FAR *szValidationCode,   /*  INPUT: App's validation code      */
   CONST char FAR *szYourName,         /*  INPUT: Your name (if registered)  */
   unsigned long int nYourKey,         /*  INPUT: Your key (if registered)   */
   RKVALID FAR *peRegistered);         /* OUTPUT: Is key valid               */


/* RegKeyFileGenerate()                                                      */
/*                                                                           */
/* Generates a file-based registration key for a particular user, using the  */
/* secret generation code corresponding to a particular application (as      */
/* passeed to RegKeyNewCodeSet()). The registration string is usually the    */
/* name of the registered user, but may also contain other information, such */
/* as the version registered or date of expiry. The registration string may  */
/* be zero to 64K characters in length, and is null-terminated. A            */
/* registration key file is generated, using the specified filename,         */
/* containing the registration string and the resulting registration key.    */
/* If a file with the specified name already exists, it is overwritten.      */
/* szRandomSeed should contain 10 random numbers and upper-case letters,     */
/* which are required during the registration key generation process.        */
/*                                                                           */
/* This function is called by KeyGen or your own registration key generation */
/* utility, each time a registration key is generated for a new user. This   */
/* function is used for file-based registration keys; compare with           */
/* RegKeyGenerate().                                                         */

RKFUNCDEF RKRETURN RegKeyFileGenerate(
   CONST char FAR *szRegString,        /*  INPUT: Registration string        */
   CONST char FAR *szGenerationCode,   /*  INPUT: App's generation code      */
   CONST char FAR *szRandomSeed,       /*  INPUT: Random number seed         */
   CONST char FAR *szFileName);        /*  INPUT: Registration key file name */


/* RegKeyFileValidate()                                                      */
/*                                                                           */
/* Checks whether the specified registration key file is valid for a         */
/* particular application, using the application-specified validation code   */
/* that was generated by RegKeyNewCodeSet(). The RKVALID pointed to by       */
/* peRegistered is set to either RK_REGISTERED or RK_UNREGISTERED,           */
/* indicating whether or not the registration key and registration string    */
/* stored in the registration key file are valid. The szFileName parameter   */
/* may include wildcards. If you have registered RegKey, your own name and   */
/* RegKey registration key should be passed to this function to diable the   */
/* RegKey "unregistered" message.                                            */
/*                                                                           */
/* This function is called from within your application each time it         */
/* executes, in order to determine whether it should operate in registered   */
/* or unregistered mode. This function is used with file-based registration  */
/* keys; compare with RegKeyValidate().                                      */

RKFUNCDEF RKRETURN RegKeyFileValidate(
   CONST char FAR *szFileName,         /*  INPUT: Registration key file name */
   CONST char FAR *szValidationCode,   /*  INPUT: App's validation code      */
   CONST char FAR *szYourName,         /*  INPUT: Your name (if registered)  */
   unsigned long int nYourKey,         /*  INPUT: Your key (if registered)   */
   char FAR *szRegString,              /* OUTPUT: Registration string        */
   unsigned short int cbMaxStringSize, /*  INPUT: Size of reg. string        */
   RKVALID FAR *peRegistered);         /* OUTPUT: Is key valid               */

#endif /* !defined(NOT_C_TARGET) */

#endif /* defined(REGKEY_H) */
