
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>

class report {

   private:

      FILE  
            *out_Fp;                  //Output File for modes 2 & 3

      int

            currentline_i,            //Current line on screen/printer
            topmargin_i,              //Number of blank lines on top
            bottommargin_i,           //Number of blank lines on bottom
            linesonpage_i,            //TOTAL number of lines on page
            pagewidth_i,              //Max Output Width (in characters)
            outputtype_i,             //1=screen, 2=printer, 3=file 4=tempfile
            pagenumber_i,             //Current page number of output
            numplines_i,              //Number of lines of pageheader
            numdlines_i,              //Number of lines of dataheader
            numglines_i;              //Number of lines of grandtotalheader

      char  programname_s[10],        //Program name for top line
            pageheader1_s[145],       //First  line of page header
            pageheader2_s[145],       //Second line of page header
            pageheader3_s[145],       //Third  line of page header
            dataheader1_s[145],       //First  line of data header
            dataheader2_s[145],       //Second line of data header
            grandtotalheader1_s[145], //First  line of grand total header
            grandtotalheader2_s[145]; //Second line of grand total header

      void  newpage(int);           //Ejects a new page w/headers on the
				    //current output device.
      void  putpageheader();        //Puts the actual page header.
      void  blankline(int);         //Skips a blank line on output device
      void  outline(char *);        //Actually outputs current line

   public:

      report(FILE *, int, char *,char *,char *,char *,
                          char *,char *,char *,char *);//Constructor w/output
						       //device and headers.
      ~report();                                       //Descructor
      void showfile(char *);                           //Outputs File.
      void setheaders(char *, char *, char *, char *, 
		      char *, char *, char *, char *); //Optional header
						       //setting routine.
      void sendline(char *);                           //Accepts line for
						       //output to device.
};

//
// REPORT::REPORT Constructor
//
// Constructor, accepts output device type and initial headers.
//
report::report(FILE *destfp, int charsperline_i,
                             char *s1_cp, char *s2_cp, char *s3_cp, char *s4_cp,
                             char *s5_cp, char *s6_cp, char *s7_cp, char *s8_cp)
{
   if (destfp==stdout)      outputtype_i = 1;
   else if (destfp==stdprn) outputtype_i = 2;
   else                     outputtype_i = 3;
   pagewidth_i = charsperline_i;
   currentline_i = 0;
   topmargin_i = 1;
   bottommargin_i = 1;
   pagenumber_i = 1;
   out_Fp = destfp;

   switch(outputtype_i) {
      case 1 : linesonpage_i = 24;
               break;
      case 2 :
      case 3 : linesonpage_i = 66;
               break;
   }
   linesonpage_i -= (topmargin_i + bottommargin_i);

   setheaders(s1_cp,s2_cp,s3_cp,s4_cp,s5_cp,s6_cp,s7_cp,s8_cp);

   switch(outputtype_i) {
      case 1 : newpage(1);
               break;
      case 2 :
      case 3 : newpage(1);
               break;
   }
}

//
// REPORT::~REPORT
//
// Destructor, waits for keypress on screen, closes files for other modes.
//
report::~report()
{
   switch(outputtype_i) {
      case 1 :
               break;
      case 2 :
      case 3 :
               fprintf(out_Fp,"%c",12);
               break;
   }
}

//
// REPORT::SHOWFILE
//
// Open and output the given file using the "report" format.
//
void report::showfile(char *fname_cp)
{
FILE *in_Fp;
char tstr_s[145];

   in_Fp = fopen(fname_cp,"r");

   fgets(tstr_s,132,in_Fp);
   while(!feof(in_Fp)) {
      sendline(tstr_s);
      fgets(tstr_s,132,in_Fp);
   }                     

   fclose(in_Fp);
}

//
// REPORT::SETHEADERS
//
// Original independent routine to set headers.
// But, I realized I needed to set the headers in the constructor
// so the initial page ejection would have headers.
//
void report::setheaders(char *s1_cp, char *s2_cp, char *s3_cp, char *s4_cp,
                        char *s5_cp, char *s6_cp, char *s7_cp, char *s8_cp)
{
   strcpy(programname_s,s1_cp);
   strcpy(pageheader1_s,s2_cp);
   strcpy(pageheader2_s,s3_cp);
   strcpy(pageheader3_s,s4_cp);
   strcpy(dataheader1_s,s5_cp);
   strcpy(dataheader2_s,s6_cp);
   strcpy(grandtotalheader1_s,s7_cp);
   strcpy(grandtotalheader2_s,s8_cp);
   numplines_i = (strlen(pageheader1_s)!=0) + (strlen(pageheader2_s)!=0) +
                 (strlen(pageheader3_s)!=0);
   numdlines_i = (strlen(dataheader1_s)!=0) + (strlen(dataheader2_s)!=0);
   numglines_i = (strlen(grandtotalheader1_s)!=0) +
                 (strlen(grandtotalheader2_s)!=0);
}

//
// REPORT::SENDLINE
//
// Outputs intermediate headers before outputing actual lines.
//
void report::sendline(char *str_cp)
{
char spaces_s[132];

   switch(*str_cp) {
      case '!' : if ((currentline_i+numdlines_i+3)>linesonpage_i) newpage(0);
                     blankline(1);
                 break;
      case '@' : break;
      case '#' : if ((currentline_i+numglines_i+2)>linesonpage_i) newpage(0);
                     blankline(2);
                 if (strlen(grandtotalheader1_s)>0) {
                    memset(spaces_s,0,sizeof(spaces_s));
                    memset(spaces_s,' ',
                      (pagewidth_i-(strlen(grandtotalheader1_s)+10+10+2))/2-1);
                    fprintf(out_Fp,"            %s%s%s          \n",
                            spaces_s,grandtotalheader1_s,spaces_s);
                 }
                 if (strlen(grandtotalheader2_s)>0) {
                    memset(spaces_s,0,sizeof(spaces_s));
                    memset(spaces_s,' ',
                      (pagewidth_i-(strlen(grandtotalheader2_s)+10+10+2))/2-1);
                    fprintf(out_Fp,"            %s%s%s          \n",
                           spaces_s,grandtotalheader2_s,spaces_s);
                 }
                 break;
      case '$' : break;
   }
   outline(str_cp+1);
}

//
// REPORT::NEWPAGE
//
// Ejects a new page on output device.  Bumps up page counter.
//
void report::newpage(int firstpass_i)
{
   switch(outputtype_i) {
      case 1 : if (!firstpass_i) getch();
               clrscr(); 
               putpageheader();
               break;
      case 2 :
      case 3 : if (!firstpass_i) fprintf(out_Fp,"%c",12);
               putpageheader();
               break;
   }
   pagenumber_i++;
}

//
// REPORT::PUTPAGEHEADER
//
// Outputs the current page headers w/dates, times, and page numbers.
//
void report::putpageheader()
{
struct date tdate;            //Date structure from getdate.
struct time ttime;            //Time structure from gettime.
char datestr_s[9],timestr_s[9], spaces_s[132];

   blankline(topmargin_i);

   getdate(&tdate);
   gettime(&ttime);
   sprintf(datestr_s,"%02d/%02d/%02d",tdate.da_mon,tdate.da_day,tdate.da_year);
   sprintf(timestr_s,"%02d:%02d:%02d",ttime.ti_hour,ttime.ti_min,ttime.ti_sec);

   memset(spaces_s,0,sizeof(spaces_s));
   memset(spaces_s,' ',(pagewidth_i-(strlen(pageheader1_s)+10+10+2))/2-1);
   fprintf(out_Fp,"  %-10.10s%s%s%s* %-8.8s\n",
          programname_s,spaces_s,pageheader1_s,spaces_s,datestr_s);

   memset(spaces_s,0,sizeof(spaces_s));
   memset(spaces_s,' ',(pagewidth_i-(strlen(pageheader2_s)+10+10+2))/2-1);
   fprintf(out_Fp,"            %s%s%s* %-8.8s\n",
          spaces_s,pageheader2_s,spaces_s,timestr_s);

   memset(spaces_s,0,sizeof(spaces_s));
   memset(spaces_s,' ',(pagewidth_i-(strlen(pageheader3_s)+10+10+2))/2-1);
   fprintf(out_Fp,"            %s%s%s* Page %3d\n",
          spaces_s,pageheader3_s,spaces_s,pagenumber_i);

   blankline(2);
   currentline_i = 5 + topmargin_i;
}

//
// REPORT::BLANKLINE
//
// Ejects a blank line to the output device.
//
void report::blankline(int numlines_i)
{
int i;

   for(i=0;i<numlines_i;i++) {
      currentline_i++;
      switch(outputtype_i) {
         case 1 : fprintf(out_Fp,"\n");
                  break;
         case 2 :
         case 3 : fprintf(out_Fp,"\n");
                  break;
      }
   }
}

//
// REPORT::OUTLINE
//
// Actual output of line to be printed.
//
void report::outline(char *str_cp)
{
   currentline_i++;
   fprintf(out_Fp,"%s",str_cp);
   if (currentline_i>=linesonpage_i) {
      currentline_i = 0;
      newpage(0);
   }
}


/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
int main()
{
#define FORM1

/***********************************************************************/
/* Output to Screen                                                    */
#ifdef FORM1
   report firstreport(stdout, 80, "DPPKNSUM",
                     "Page Header Line Number 1",
                     "Page Header Line Number 2",
                     "Page Header Line Number 3",
                     "Data Header Line 1",
                     "Data Header Line 2",
                     "Grand Total Line 1",
                     "Grand Total Line 2");

   firstreport.showfile("tempfile.txt");
#endif

/***********************************************************************/
/* Output to Printer                                                   */
#ifdef FORM2
   report firstreport(stdprn, 80, "DPPKNSUM",
                     "Page Header Line Number 1",
		     "Page Header Line Number 2",
		     "Page Header Line Number 3",
		     "Data Header Line 1",
		     "Data Header Line 2",
		     "Grand Total Line 1",
		     "Grand Total Line 2");

   firstreport.showfile("tempfile.txt");
#endif

/***********************************************************************/
/* Output to File                                                      */
#ifdef FORM3
   FILE *ofp;

   ofp = fopen("outfile.txt","w");
   report firstreport(ofp, 80, "DPPKNSUM",
                     "Page Header Line Number 1",
                     "Page Header Line Number 2",
                     "Page Header Line Number 3",
                     "Data Header Line 1",
                     "Data Header Line 2",
                     "Grand Total Line 1",
                     "Grand Total Line 2");

   firstreport.showfile("tempfile.txt");
   fclose(ofp);
#endif

}
