/* test.c -- dap@kandy.com 01/21/94 */
/*
   syntax: test "string" "regular expression"

   example: test "hello world" "lo.*"
   the above example should match.

   This program won't give the regular expression functions a complete
   workout, but should serve to show whether or not they are completely
   broken, as well as demonstrate how to hook up the functions in your
   program.

   Read regexp.man for further info on regular expressions. Regular
   expressions are a complex subject, one that entire textbooks have
   been written about. Becoming a regular expressions wizard is not a
   trivial undertaking, but OTOH, anyone with a little appreciation of
   how regular expressions work can make their life a whole lot easier.
   Basically, they are "wildcards" with jet power and afterburners.

   Compile and link with regexp.obj , regsub.obj , and regerror.obj
   Or, roll the above 3 obj files into a .lib , and link with that.

*/

#include <stdio.h>
#include "regexp.h"

char buf[1024];

main(int argc, char **argv)
{
  regexp *ourpointer; /* Our pointer to a struc of type regexp */

  /* Before we can use a regular expression, we have to compile it
     with regcomp(), which will malloc a structure of type regexp,
     and return a pointer to it. Note the associated free() statement
     at the end of this program.

     If regcomp() fails, it automatically generates an error message
     to stderr, then returns NULL.
  */
  if((ourpointer=regcomp(argv[2]))==NULL)
    exit(1);

  /* We can now test for a match by calling regexec() using the pointer
     to our compiled expression, and a pointer to the string.

     regexec() returns 1 for success, or 0 for failure.
  */

  if(regexec(ourpointer, argv[1]))
  {
    printf("regexec() found a match\n");
    /* Once regexec() succeeds, we can get to the matched substring two
       ways. The first is simply to use the pointers to the beginning
       and end of the substring.
    */
    printf("Printing string using pointers: ");
    fwrite(ourpointer->startp[0], sizeof (char),
	   (size_t)(ourpointer->endp[0] - ourpointer->startp[0]),
	   stdout);
    /* The second is to do a copy-and-substitute using regsub().
    */
    regsub(ourpointer,
	   "\nregsub() says that `&' is the substring, and so is `\\0'!",
	   buf);
    printf("%s\n", buf);
  }
  else
  {
    printf("regexec() did not find a match\n");
  }

  /* Free the structure that regcomp() malloc'ed */
  free(ourpointer);
}
