/* Driver for routine PIKSR2 */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NP 100
#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	int i,j;
	float *a,*b;
	FILE *fp;

	a=vector(1,NP);
	b=vector(1,NP);
	if ((fp = fopen("tarray.dat","r")) == NULL)
		nrerror("Data file TARRAY.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	for (i=1;i<=NP;i++) fscanf(fp,"%f",&a[i]);
	fclose(fp);
	/* generate b-array */
	for (i=1;i<=NP;i++) b[i]=i-1;
	/* sort a and mix b */
	piksr2(NP,a,b);
	printf("\nAfter sorting a and mixing b, array a is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",a[10*i+j]);
		printf("\n");
	}
	printf("\n... and array b is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",b[10*i+j]);
		printf("\n");
	}
	printf("press return to continue ...\n");
	getchar();
	/* sort b and mix a */
	piksr2(NP,b,a);
	printf("\nAfter sorting b and mixing a, array a is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",a[10*i+j]);
		printf("\n");
	}
	printf("\n... and array b is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",b[10*i+j]);
		printf("\n");
	}
	free_vector(b,1,NP);
	free_vector(a,1,NP);
}
