/* Driver for routine GASDEV */

#include <stdio.h>
#include "nr.h"

#define N 20
#define NOVER2 (N/2)
#define NPTS 2000
#define ISCAL 400
#define LLEN 50

main()
{
	char words[LLEN+1];
	int i,idum=(-13),j,k,klim,dist[N+1];
	float dd;

	for (j=0;j<=N;j++) dist[j]=0;
	for (i=1;i<=NPTS;i++) {
		j=(int) (0.5+0.25*N*gasdev(&idum));
		if ((j >= -NOVER2) && (j <= NOVER2)) ++dist[j+NOVER2];
	}
	printf("Normally distributed deviate of %6d points\n",NPTS);
	printf ("%5s %10s %9s\n","x","p(x)","graph:");
	for (j=0;j<=N;j++) {
		dd=(float) dist[j]/NPTS;
		for (k=1;k<=LLEN;k++) words[k]=' ';
		klim=ISCAL*dd;
		if (klim > LLEN)  klim=LLEN;
		for (k=1;k<=klim;k++) words[k]='*';
		printf("%8.4f %8.4f  ",j/(0.25*N),dd);
		for (k=1;k<=LLEN;k++) printf("%c",words[k]);
		printf("\n");
	}
}
