/* Driver for routine FACTLN */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	int i,n,nval,strncmp();
	float val;
	FILE *fp;

	if ((fp = fopen("fncval.dat","r")) == NULL)
		nrerror("Data file FNCVAL.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	while(strncmp(txt,"N-factorial",11)) {
		fgets(txt,MAXSTR,fp);
		if (feof(fp)) return;
	}
	fscanf(fp,"%d %*s",&nval);
	printf("\nlog of n_factorial\n");
	printf("\n%6s %19s %21s\n","n","actual","factln(n)");
	for (i=1;i<=nval;i++) {
		fscanf(fp,"%d %f",&n,&val);
		printf("%6d %20.7f %20.7f\n",n,log(val),factln(n));
	}
	fclose(fp);
}
