/* Driver for routine SPARSE */

#include <stdio.h>
#include "nr.h"

#define N 20

void asub(xin,xout,n)
float xin[],xout[];
int n;
{
	int i;

	xout[1]=xin[1]+2.0*xin[2];
	xout[n] = -2.0*xin[n-1]+xin[n];
	for (i=2;i<n;i++)
		xout[i] = -2.0*xin[i-1]+xin[i]+2.0*xin[i+1];
}

void atsub(xin,xout,n)
float xin[],xout[];
int n;
{
	int i;

	xout[1]=xin[1]-2.0*xin[2];
	xout[n]=2.0*xin[n-1]+xin[n];
	for (i=2;i<n;i++)
		xout[i]=2.0*xin[i-1]+xin[i]-2.0*xin[i+1];
}

main()
{
	int i,ii;
	float rsq;
	float b[N+1],bcmp[N+1],x[N+1];

	for (i=1;i<=N;i++) {
		x[i]=0.0;
		b[i]=1.0;
	}
	b[1]=3.0;
	b[N] = -1.0;
	sparse(b,N,x,&rsq);
	printf("%s %15f\n","sum-squared residual:",rsq);
	printf("\nsolution vector:\n");
	for (ii=1;ii<=N/5;ii++)
	{
		for (i=5*(ii-1)+1;i<=5*ii;i++) printf("%12.6f",x[i]);
		printf("\n");
	}
	for (i=1;i<=(N % 5);i++)
		printf("%12.6f",x[5*(N/5)+i]);
	printf("\n");
	asub(x,bcmp,N);
	printf("\npress RETURN to continue...\n");
	getchar();
	printf("test of solution vector:\n");
	printf("%9s %12s\n","a*x","b");
	for (i=1;i<=N;i++)
		printf("%12.6f %12.6f\n",bcmp[i],b[i]);
}
