/* Driver for routine SMOOFT */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define N 100
#define HASH 0.05
#define SCALE 100.0
#define PTS 10.0
#define M 256		/* first integral power of 2 that
			is greater or equal to (N+2*PTS) */

main()
{
	int i,idum=(-7),j,k,nstp,bar;
	float *y;
	char txt[52];

	y=vector(1,M);
	for (i=1;i<=N;i++) {
		y[i]=3.0*i/N*exp(-3.0*i/N);
		y[i] += (HASH*gasdev(&idum));
	}
	for (k=1;k<=3;k++) {
		nstp=N/20;
		printf("\n%8s %12s\n","data","graph");
		for (i=1;i<=20*nstp;i += nstp) {
			bar=(int) (0.5+SCALE*y[i]);
			for (j=1;j<=50;j++)
				txt[j]=(j <= bar ? '*': ' ');
			txt[51]='\0';
			printf("%10.6f %4s %s\n",y[i]," ",txt+1);
		}
		if (k == 3) break;
		printf("press return to smooth ...\n");
		getchar();
		smooft(y,N,PTS);
	}
	free_vector(y,1,M);
}
