/* Driver for routine RAN4 */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NPT 50

main()
{
	int idum=(-123),j;
	float ave,vrnce,*y;

	y=vector(1,NPT);
	printf("\nFirst 10 Random Numbers with idum = %5d\n\n",idum);
	printf("%4s %11s \n","#","RAN4");
	for (j=1;j<=10;j++) {
		y[j]=ran4(&idum);
		printf("%4d %12.6f\n",j,y[j]);
	}
	printf("\nAverage and Variance of Next %3d\n",NPT);
	for (j=1;j<=NPT;j++)
		y[j]=ran4(&idum);
	avevar(y,NPT,&ave,&vrnce);
	printf("\nAverage: %10.4f\nVariance: %9.4f\n",ave,vrnce);
	printf("\nExpected Result for an Infinite Sample:\n");
	printf("\nAverage: %10.4f\nVariance: %9.4f\n",0.5,0.0833333);
	free_vector(y,1,NPT);
}
