/* Driver for routine MNEWT */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define SQR(a) ((a)*(a))

void usrfun(x,alpha,bet)
float *x,**alpha,*bet;
{
	alpha[1][1] = -2.0*x[1];
	alpha[1][2] = -2.0*x[2];
	alpha[1][3] = -2.0*x[3];
	alpha[1][4]=1.0;
	alpha[2][1]=2.0*x[1];
	alpha[2][2]=2.0*x[2];
	alpha[2][3]=2.0*x[3];
	alpha[2][4]=2.0*x[4];
	alpha[3][1]=1.0;
	alpha[3][2] = -1.0;
	alpha[3][3]=0.0;
	alpha[3][4]=0.0;
	alpha[4][1]=0.0;
	alpha[4][2]=1.0;
	alpha[4][3] = -1.0;
	alpha[4][4]=0.0;
	bet[1]=SQR(x[1])+SQR(x[2])+SQR(x[3])-x[4];
	bet[2] = -SQR(x[1])-SQR(x[2])-SQR(x[3])-SQR(x[4])+1.0;
	bet[3] = -x[1]+x[2];
	bet[4] = -x[2]+x[3];
}

#define NTRIAL 5
#define TOLX 1.0e-6
#define N 4
#define TOLF 1.0e-6

main()
{
	int i,j,k,kk;
	float xx,*x,*bet,**alpha;

	alpha=matrix(1,N,1,N);
	bet=vector(1,N);
	x=vector(1,N);
	for (kk=1;kk<=2;kk++) {
		for (k=1;k<=3;k++) {
			xx=0.21*k*(2*kk-3);
			printf("Starting vector number %2d\n",k);
			for (i=1;i<=4;i++) {
				x[i]=xx+0.2*i;
				printf("%7s%1d%s %5.2f\n",
					"x[",i,"] = ",x[i]);
			}
			printf("\n");
			for (j=1;j<=NTRIAL;j++) {
				mnewt(1,x,N,TOLX,TOLF);
				usrfun(x,alpha,bet);
				printf("%5s %13s %13s\n","i","x[i]","f");
				for (i=1;i<=N;i++)
					printf("%5d %14.6f %15.6f\n",
						i,x[i],-bet[i]);
				printf("\npress RETURN to continue...\n");
				getchar();
			}
		}
	}
	free_vector(x,1,N);
	free_vector(bet,1,N);
	free_matrix(alpha,1,N,1,N);
}
