/* Driver for routine MDIAN1 */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NPTS 50

main()
{
	int i,j,idum=(-5);
	float xmed,*data;

	data=vector(1,NPTS);
	for (i=1;i<=NPTS;i++) data[i]=gasdev(&idum);
	mdian1(data,NPTS,&xmed);
	printf("\nData drawn from a gaussian distribution\n");
	printf("with zero mean and unit variance\n\n");
	printf("Median of data set is %9.6f\n\n",xmed);
	printf("Sorted data\n");
	for (i=1;i<=NPTS/5;i++) {
		for (j=1;j<=5;j++) printf("%12.6f",data[5*i-5+j]);
		printf("\n");
	}
	free_vector(data,1,NPTS);
}
