/* Driver for routine IRBIT1 */

#include <stdio.h>
#include "nr.h"

#define NBIN 15
#define NTRIES 4000

main()
{
	int i,iflg,ipts=0,j,n;
	unsigned long int iseed=12345;
	float twoinv,delay[NBIN+1];

	/* Calculate distribution of runs of zeros */
	for (i=1;i<=NBIN;i++) delay[i]=0.0;
	printf("distribution of runs of n zeros\n");
	printf("%6s %22s %18s\n","n","probability","expected");
	for (i=1;i<=NTRIES;i++) {
		if (irbit1(&iseed) == 1) {
			++ipts;
			iflg=0;
			for (j=1;j<=NBIN;j++) {
				if ((irbit1(&iseed) == 1) && (iflg == 0)) {
					iflg=1;
					delay[j] += 1.0;
				}
			}
		}
	}
	twoinv=0.5;
	for (n=1;n<=NBIN;n++) {
		printf("%6d %19.4f %20.4f\n",
			(n-1),delay[n]/ipts,twoinv);
		twoinv /= 2.0;
	}
}
