/* Driver for routine FLMOON */

#include <stdio.h>
#include "nr.h"

#define ZON -5.0

main()
{
	int i,i1,i2,i3,id,im,iy,n,nph;
	float timzon = ZON/24.0,frac,secs;
	long j1,j2;
	static char *phase[]={"new moon","first quarter",
		"full moon","last quarter"};

	printf("Date of the next few phases of the moon\n");
	printf("Enter today\'s date (e.g. 1 31 1982)  :  \n");
	scanf("%d %d %d",&im,&id,&iy);
	/* Approximate number of full moons since january 1900 */
	n=12.37*(iy-1900+((im-0.5)/12.0));
	nph=2;
	j1=julday(im,id,iy);
	flmoon(n,nph,&j2,&frac);
	n += (float) (j1-j2)/28.0;
	printf("\n%10s %19s %9s\n","date","time(EST)","phase");
	for (i=1;i<=20;i++) {
		flmoon(n,nph,&j2,&frac);
		frac=24.0*(frac+timzon);
		if (frac < 0.0) {
			--j2;
			frac += 24.0;
		}
		if (frac > 12.0) {
			++j2;
			frac -= 12.0;
		} else
			frac += 12.0;
		i1=(int) frac;
		secs=3600.0*(frac-i1);
		i2=(int) secs/60.0;
		i3=(int) (secs-60*i2+0.5);
		caldat(j2,&im,&id,&iy);
		printf("%5d %3d %5d %7d:%2d:%2d      %s\n",
			im,id,iy,i1,i2,i3,phase[nph]);
		if (nph == 3) {
			nph=0;
			++n;
		} else
			++nph;
	}
}
