/* Driver for routine DES */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

/* Converts character representing hexadecimal number to its integer
value in a machine-independent way. */
int hex2int(ch)
char ch;
{
	return ch >= '0' && ch <= '9' ? (int) (ch-'0') : (int) (ch-'A'+10);
}

/* Inverse of hex2int */
char int2hex(i)
int i;
{
	return i <= 9 ? (char) (i+'0') : (char) (i-10+'A');
}

/* Reverse bits of type immense */
void reverse(input)
immense *input;
{
	immense temp;
	int i;

	temp.r=temp.l=0L;
	for (i=1;i<=32;i++) {
		temp.r = (temp.r <<= 1) | ((*input).l & 1L);
		temp.l = (temp.l <<= 1) | ((*input).r & 1L);
		(*input).r >>= 1;
		(*input).l >>= 1;
	}
	(*input).r=temp.r;
	(*input).l=temp.l;
}

extern unsigned long bit[];

main()
{
	int i,idirec,j,m,mm,nciphr,newkey,strncmp();
	immense iin,iout,key;
	char hin[18],hkey[18],hout[18],hcmp[18];
	char verdct[8],txt[61],txt2[9],*strcpy();
	FILE *fp;

	if ((fp = fopen("destst.dat","r")) == NULL)
		nrerror("Data file DESTST.DAT not found\n");
	fgets(txt,60,fp);
	printf("\n%s",txt);
	for (;;) {
		fgets(txt,60,fp);
		printf("%s",txt);
		fscanf(fp,"%d %*s ",&nciphr);
		if (feof(fp)) break;
		fgets(txt2,8,fp);
		if (strncmp(txt2,"encode",6) == 0) idirec=0;
		if (strncmp(txt2,"decode",6) == 0) idirec=1;
		do {
			printf("%8s %20s %20s %15s\n","key","plaintext",
				"expected cipher","actual cipher");
			mm=16;
			if (nciphr < 16) mm=nciphr;
			nciphr -= 16;
			for (m=1;m<=mm;m++) {
				fscanf(fp,"%s %s %s ",hkey+1,hin+1,hcmp+1);
				iin.l=iin.r=key.l=key.r=0L;
				for (i=1,j=9;i<=8;i++,j++) {
					iin.l=(iin.l <<= 4) | hex2int(hin[i]);
					key.l=(key.l <<= 4) | hex2int(hkey[i]);
					iin.r=(iin.r <<= 4) | hex2int(hin[j]);
					key.r=(key.r <<= 4) | hex2int(hkey[j]);
				}
				newkey=1;
				reverse(&iin);
				reverse(&key);
				des(iin,key,&newkey,idirec,&iout);
				reverse(&iout);
				for (i=8,j=16;i>=1;i--,j--) {
					hout[i]=int2hex((int) (iout.l & 0xf));
					hout[j]=int2hex((int) (iout.r & 0xf));
					iout.l >>= 4;
					iout.r >>= 4;
				}
				hout[17]='\0';
				strncmp(hcmp+1,hout+1,16) == 0 ?
					strcpy(verdct,"o.k.") :
					strcpy(verdct,"wrong");
				printf("%16s %16s %16s %16s %s\n",
					hkey+1,hin+1,hcmp+1,hout+1,verdct);
			}
			printf("Press RETURN to continue ...\n");
			getchar();
		} while (nciphr > 0);
	}
}
