/* Driver for routine BESSI */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	int i,nval,n,strncmp();
	float val,x;
	FILE *fp;

	if ((fp = fopen("fncval.dat","r")) == NULL)
		nrerror("Data file FNCVAL.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	while(strncmp(txt,"Modified Bessel Function In",27)) {
		fgets(txt,MAXSTR,fp);
		if (feof(fp)) return;
	}
	fscanf(fp,"%d %*s",&nval);
	printf("\n%s\n",txt);
	printf("%4s %7s %15s %20s\n","n","x","actual","bessi(n,x)");
	for (i=1;i<=nval;i++) {
		fscanf(fp,"%d %f %f",&n,&x,&val);
		printf("%4d %8.2f %18.7e %18.7e\n",n,x,val,bessi(n,x));
	}
	fclose(fp);
}
