/* Driver for routine RANK */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NP 100
#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	int i,j,k,l,*indx,*irank;
	float *a,b[11];
	FILE *fp;

	indx=ivector(1,NP);
	irank=ivector(1,NP);
	a=vector(1,NP);
	if ((fp = fopen("tarray.dat","r")) == NULL)
		nrerror("Data file TARRAY.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	for (i=1;i<=NP;i++) fscanf(fp,"%f",&a[i]);
	fclose(fp);
	indexx(NP,a,indx);
	rank(NP,indx,irank);
	printf("original array is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",a[10*i+j]);
		printf("\n");
	}
	printf("table of ranks is:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7d",irank[10*i+j]);
		printf("\n");
	}
	printf("press return to continue...\n");
	getchar();
	printf("array sorted according to rank table:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) {
			k=10*i+j;
			for (l=1;l<=NP;l++)
				if (irank[l] == k) b[j]=a[l];
		}
		for (j=1;j<=10;j++) printf("%7.2f",b[j]);
		printf("\n");
	}
	free_vector(a,1,NP);
	free_ivector(irank,1,NP);
	free_ivector(indx,1,NP);
}
