/* Driver for routine RAN2 */

#include <stdio.h>
#include <math.h>
#include "nr.h"

#define PI 3.1415926

float fnc(x1,x2,x3,x4)
float x1,x2,x3,x4;
{
	return (float) sqrt(x1*x1+x2*x2+x3*x3+x4*x4);
}

int twotoj(j)
int j;
{
	return j == 0 ? 1 : 2*twotoj(j-1);
}

main()
{
	long idum=(-1);
	int i,j,k,jpower,iy[4];
	float x1,x2,x3,x4,yprob[4];

	/* Calculates pi statistically using volume of unit n-sphere */
	for (i=1;i<=3;i++) iy[i]=0;
	printf("\nvolume of unit n-sphere, n=2,3,4\n");
	printf("# points      pi        (4/3)*pi   (1/2)*pi^2 \n\n");
	for (j=1;j<=14;j++) {
		for (k=twotoj(j-1);k<=twotoj(j);k++) {
			x1=ran2(&idum);
			x2=ran2(&idum);
			x3=ran2(&idum);
			x4=ran2(&idum);
			if (fnc(x1,x2,0.0,0.0) < 1.0) ++iy[1];
			if (fnc(x1,x2,x3,0.0) < 1.0) ++iy[2];
			if (fnc(x1,x2,x3,x4) < 1.0) ++iy[3];
		}
		jpower=twotoj(j);
		yprob[1]=4.0*iy[1]/jpower;
		yprob[2]=8.0*iy[2]/jpower;
		yprob[3]=16.0*iy[3]/jpower;
		printf("%6d %12.6f %12.6f %12.6f\n",
			jpower,yprob[1],yprob[2],yprob[3]);
	}
	printf("\nactual %12.6f %12.6f %12.6f\n",
		PI,4.0*PI/3.0,0.5*PI*PI);
}
