/* Driver for routine RAN0 */

#include <stdio.h>
#include <math.h>
#include "nr.h"

#define PI 3.1415926

int twotoj(j)
int j;
{
	return j == 0 ? 1 : 2*twotoj(j-1);
}

float fnc(x1,x2,x3,x4)
float x1,x2,x3,x4;
{
	return (float) sqrt(x1*x1+x2*x2+x3*x3+x4*x4);
}

main()
{
	int i,idum=(-1),j,k,jpower;
	float x1,x2,x3,x4;
	float iy[4],yprob[4];

	/* Calculates PI statistically using volume of unit n-sphere */
	for (i=1;i<=3;i++) iy[i]=0;
	printf("\nvolume of unit n-sphere, n = 2,3,4\n");
	printf("# points      PI        (4/3)*PI    (1/2)*PI^2\n\n");
	for (j=1;j<=14;j++) {
		for (k=twotoj(j-1);k<=twotoj(j);k++) {
			x1=ran0(&idum);
			x2=ran0(&idum);
			x3=ran0(&idum);
			x4=ran0(&idum);
			if (fnc(x1,x2,0.0,0.0) < 1.0) ++iy[1];
			if (fnc(x1,x2,x3,0.0) < 1.0) ++iy[2];
			if (fnc(x1,x2,x3,x4) < 1.0) ++iy[3];
		}
		jpower=twotoj(j);
		yprob[1]=4.0*iy[1]/jpower;
		yprob[2]=8.0*iy[2]/jpower;
		yprob[3]=16.0*iy[3]/jpower;
		printf("%6d %12.6f %12.6f %12.6f\n",
			jpower,yprob[1],yprob[2],yprob[3]);
	}
	printf("\nactual %12.6f %12.6f %12.6f\n",
		PI,4.0*PI/3.0,0.5*PI*PI);
}
