/* Driver for routine PZEXTR */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NV 4
#define NUSE 5
#define IMAX 10

float **d=0,*x=0;	/* defining declaration */

main()
{
	int i,iest,j;
	float dum,xest,*dy,*yest,*yz;

	dy=vector(1,NV);
	yest=vector(1,NV);
	yz=vector(1,NV);
	x=vector(1,IMAX);
	d=matrix(1,NV,1,NUSE);
	/* Feed values from a rational function */
	/* fn(x)=(1-x+x**3)/(x+1)**n */
	for (i=1;i<=IMAX;i++) {
		iest=i;
		xest=1.0/i;
		dum=1.0-xest+xest*xest*xest;
		for (j=1;j<=NV;j++) {
			dum /= (xest+1.0);
			yest[j]=dum;
		}
		pzextr(iest,xest,yest,yz,dy,NV,NUSE);
		printf("\ni = %2d",i);
		printf("\nExtrap. function:");
		for (j=1;j<=NV;j++) printf("%12.6f",yz[j]);
		printf("\nEstimated error: ");
		for (j=1;j<=NV;j++) printf("%12.6f",dy[j]);
		printf("\n");
	}
	printf("\nactual values: %14.6f %11.6f %11.6f %11.6f\n",
		1.0,1.0,1.0,1.0);
	free_matrix(d,1,NV,1,NUSE);
	free_vector(x,1,IMAX);
	free_vector(yz,1,NV);
	free_vector(yest,1,NV);
	free_vector(dy,1,NV);
}
