/* Driver for routine LFIT */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define NPT 100
#define SPREAD 0.1
#define NTERM 3

void funcs(x,afunc,mma)
float x,*afunc;
int mma;
{
	int i;

	afunc[1]=1.0;
	for (i=2;i<=mma;i++) afunc[i]=x*afunc[i-1];
}

main()
{
	int i,ii,idum=(-911),j,mfit,*lista;
	float chisq,*a,*x,*y,*sig,**covar;

	lista=ivector(1,NTERM);
	a=vector(1,NTERM);
	x=vector(1,NPT);
	y=vector(1,NPT);
	sig=vector(1,NPT);
	covar=matrix(1,NTERM,1,NTERM);
	for (i=1;i<=NPT;i++) {
		x[i]=0.1*i;
		y[i]=NTERM;
		for (j=NTERM-1;j>=1;j--)
			y[i]=j+y[i]*x[i];
		y[i] += SPREAD*gasdev(&idum);
		sig[i]=SPREAD;
	}
	mfit=NTERM;
	for (i=1;i<=mfit;i++) lista[i]=i;
	lfit(x,y,sig,NPT,a,NTERM,lista,mfit,covar,&chisq,funcs);
	printf("\n%11s %21s\n","parameter","uncertainty");
	for (i=1;i<=NTERM;i++)
		printf("  a[%1d] = %8.6f %12.6f\n",
			i,a[i],sqrt(covar[i][i]));
	printf("chi-squared = %12f\n",chisq);
	printf("full covariance matrix\n");
	for (i=1;i<=NTERM;i++) {
		for (j=1;j<=NTERM;j++) printf("%12f",covar[i][j]);
		printf("\n");
	}
	printf("\npress RETURN to continue...\n");
	getchar();
	/* Now test the LISTA feature */
	for (i=1;i<=NTERM;i++) lista[i]=NTERM+1-i;
	lfit(x,y,sig,NPT,a,NTERM,lista,mfit,covar,&chisq,funcs);
	printf("\n%11s %21s\n","parameter","uncertainty");
	for (i=1;i<=NTERM;i++)
		printf("  a[%1d] = %8.6f %12.6f\n",
			i,a[i],sqrt(covar[i][i]));
	printf("chi-squared = %12f\n",chisq);
	printf("full covariance matrix\n");
	for (i=1;i<=NTERM;i++) {
		for (j=1;j<=NTERM;j++) printf("%12f",covar[i][j]);
		printf("\n");
	}
	printf("\npress RETURN to continue...\n");
	getchar();
	/* Now check results of restricting fit parameters */
	ii=1;
	for (i=1;i<=NTERM;i++)
		if ((i % 2) == 1) lista[ii++]=i;
	mfit=ii-1;
	lfit(x,y,sig,NPT,a,NTERM,lista,mfit,covar,&chisq,funcs);
	printf("\n%11s %21s\n","parameter","uncertainty");
	for (i=1;i<=NTERM;i++)
		printf("  a[%1d] = %8.6f %12.6f\n",
			i,a[i],sqrt(covar[i][i]));
	printf("chi-squared = %12f\n",chisq);
	printf("full covariance matrix\n");
	for (i=1;i<=NTERM;i++) {
		for (j=1;j<=NTERM;j++) printf("%12f",covar[i][j]);
		printf("\n");
	}
	printf("\n");
	free_matrix(covar,1,NTERM,1,NTERM);
	free_vector(sig,1,NPT);
	free_vector(y,1,NPT);
	free_vector(x,1,NPT);
	free_vector(a,1,NTERM);
	free_ivector(lista,1,NTERM);
}
