/* Driver for routine IRBIT2 */

#include <stdio.h>
#include "nr.h"

#define NBIN 15
#define NTRIES 4000

float twoton(n)
int n;
{
	return n == 0 ? 1.0 : 2.0*twoton(n-1);
}

main()
{
	int i,iflg,ipts,j,n;
	unsigned long int iseed=111;
	float delay[NBIN+1];

	/* Calculate distribution of runs of zeros */
	for (i=1;i<=NBIN;i++) delay[i]=0.0;
	ipts=0;
	for (i=1;i<=NTRIES;i++) {
		if (irbit2(&iseed) == 1) {
			++ipts;
			iflg=0;
			for (j=1;j<=NBIN;j++) {
				if ((irbit2(&iseed) == 1) && (iflg == 0)) {
					iflg=1;
					delay[j] += 1.0;
				}
			}
		}
	}
	printf("distribution of runs of n zeros\n");
	printf("%6s %22s %18s \n","n","probability","expected");
	for (n=1;n<=NBIN;n++)
		printf("%6d %19.4f %20.4f\n",
			(n-1),delay[n]/ipts,1.0/twoton(n));
}
