/* Driver for routine INDEXX */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define NP 100
#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	int i,j,*indx;
	float *a;
	FILE *fp;

	indx=ivector(1,NP);
	a=vector(1,NP);
	if ((fp = fopen("tarray.dat","r")) == NULL)
		nrerror("Data file TARRAY.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	for (i=1;i<=NP;i++) fscanf(fp,"%f",&a[i]);
	fclose(fp);
	indexx(NP,a,indx);
	printf("\noriginal array:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",a[10*i+j]);
		printf("\n");
	}
	printf("\nsorted array:\n");
	for (i=0;i<=9;i++) {
		for (j=1;j<=10;j++) printf("%7.2f",a[indx[10*i+j]]);
		printf("\n");
	}
	free_vector(a,1,NP);
	free_ivector(indx,1,NP);
}
