/* Driver for routine COVSRT */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define MA 10
#define MFIT 5

main()
{
	int i,j,*lista;
	float **covar;

	lista=ivector(1,MFIT);
	covar=matrix(1,MA,1,MA);
	for (i=1;i<=MA;i++)
		for (j=1;j<=MA;j++) {
			covar[i][j]=0.0;
			if ((i <= 5) && (j <= 5))
				covar[i][j]=i+j-1;
		}
	printf("\noriginal matrix\n");
	for (i=1;i<=MA;i++) {
		for (j=1;j<=MA;j++) printf("%4.1f",covar[i][j]);
		printf("\n");
	}
	printf("press RETURN to continue...\n");
	getchar();
	/* Test 1 - spread by 2 */
	printf("\nTest #1 - spread by two\n");
	for (i=1;i<=MFIT;i++) lista[i]=2*i;
	covsrt(covar,MA,lista,MFIT);
	for (i=1;i<=MA;i++) {
		for (j=1;j<=MA;j++) printf("%4.1f",covar[i][j]);
		printf("\n");
	}
	printf("press RETURN to continue...\n");
	getchar();
	/* Test 2 - reverse */
	printf("\nTest #2 - reverse\n");
	for (i=1;i<=MA;i++)
		for (j=1;j<=MA;j++) {
			covar[i][j]=0.0;
			if ((i <= 5) && (j <= 5)) covar[i][j]=i+j-1;
		}
	for (i=1;i<=MFIT;i++) lista[i]=MFIT+1-i;
	covsrt(covar,MA,lista,MFIT);
	for (i=1;i<=MA;i++) {
		for (j=1;j<=MA;j++) printf("%4.1f",covar[i][j]);
		printf("\n");
	}
	printf("press RETURN to continue...\n");
	getchar();
	/* Test 3 - spread and reverse */
	printf("\nTest #3 - spread and reverse\n");
	for (i=1;i<=MA;i++)
		for (j=1;j<=MA;j++) {
			covar[i][j]=0.0;
			if ((i <= 5) && (j <= 5)) covar[i][j]=i+j-1;
		}
	for (i=1;i<=MFIT;i++) lista[i]=MA+2-2*i;
	covsrt(covar,MA,lista,MFIT);
	for (i=1;i<=MA;i++) {
		for (j=1;j<=MA;j++) printf("%4.1f",covar[i][j]);
		printf("\n");
	}
	free_matrix(covar,1,MA,1,MA);
	free_ivector(lista,1,MFIT);
}
