/* Driver for routine BALANC */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define NP 5

main()
{
	int i,j;
	float *c,*r,**a;

	c=vector(1,NP);
	r=vector(1,NP);
	a=matrix(1,NP,1,NP);
	for (i=1;i<=NP;i++)
		for (j=1;j<=NP;j++) {
			if ((i%2 == 1) && (j%2 == 0))
				a[i][j] = 100.0;
			else
				a[i][j] = 1.0;
		}
	/* Write norms */
	for (i=1;i<=NP;i++) {
		r[i]=0.0;
		c[i]=0.0;
		for (j=1;j<=NP;j++) {
			r[i] += fabs(a[i][j]);
			c[i] += fabs(a[j][i]);
		}
	}
	printf("rows:\n");
	for (i=1;i<=NP;i++) printf("%12.2f",r[i]);
	printf("\ncolumns:\n");
	for (i=1;i<=NP;i++) printf("%12.2f",c[i]);
	printf("\n\n***** Balancing matrix *****\n\n");
	balanc(a,NP);
	/* Write norms */
	for (i=1;i<=NP;i++) {
		r[i]=0.0;
		c[i]=0.0;
		for (j=1;j<=NP;j++) {
			r[i] += fabs(a[i][j]);
			c[i] += fabs(a[j][i]);
		}
	}
	printf("rows:\n");
	for (i=1;i<=NP;i++) printf("%12.2f",r[i]);
	printf("\ncolumns:\n");
	for (i=1;i<=NP;i++) printf("%12.2f",c[i]);
	printf("\n");
	free_matrix(a,1,NP,1,NP);
	free_vector(r,1,NP);
	free_vector(c,1,NP);
}
