/*****************************************************************************
   MODULE: rcgets.c
  PURPOSE: recio column delimited string and char input functions
COPYRIGHT: (C) 1994 William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.04
  RELEASE: October 10, 1994
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _rstatus(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

#define rcol(rp)         ((rp)->r_colno)

/****************************************************************************/
int                          /* return character; EOF on error              */
    rcgetc(                  /* get character at column position            */
        REC *rp,             /* record pointer                              */
        size_t col)          /* column position                             */
/****************************************************************************/
{
    int ch=EOF;              /* character */
    char *fldptr;            /* pointer to field buffer */
    
    if (!_rstatus(rp, R_READ)) {
        if (col >= rbegcolno(rp)) {
            rcol(rp) = col - rbegcolno(rp);
            fldptr = _rfldstr(rp, 1);
            if (fldptr) {
                /* loop while field empty or error cleared */
                for (;;) {
                    /* if field not empty, success */
                    if (*fldptr != '\0') {
                        ch = *fldptr;
                        goto done;
                    }
                    
                    /* field empty; see if errfn() replaces it */
                    fldptr = _rerrs(rp, R_EMISDAT);
                    if (fldptr) { continue; } else { goto done; }
                }
            }
        }
        rseterr(rp, R_EINVAL);
    }
done:
    return (ch);
}

/****************************************************************************/
char *                       /* return pointer to string; "" on error       */
    rcgets(                  /* get string between columns (inclusive)      */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* beginning column                            */
        size_t endcol)       /* ending column                               */
/****************************************************************************/
{
    static char empty[]="";  /* empty string */
    char *retp=empty;        /* return pointer */
    char *fldptr;            /* pointer to field buffer */
    
    if (!_rstatus(rp, R_READ)) {
        if (endcol >= begcol && begcol >= rbegcolno(rp)) {
            rcol(rp) = begcol - rbegcolno(rp);
            fldptr = _rfldstr(rp, endcol-begcol+1);
            if (fldptr) {
                    
                /* if field not empty, success */
                if (*fldptr) {
                    retp = fldptr;
                    goto done;
                    
                /* field empty (beyond end of record) */
                } else {
                    rsetfldstr(rp, "");
                    rsetwarn(rp, R_WEMPSTR);
                    retp = rflds(rp);
                    goto done;
                }
            }
        }
        rseterr(rp, R_EINVAL);
    }
done:
    return (retp);
}
