/*****************************************************************************
   MODULE: rbput.c
  PURPOSE: recio character delimited integral number output functions
COPYRIGHT: (C) 1994 William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.04
  RELEASE: October 10, 1994
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _rstatus(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rflags(rp)       ((rp)->r_flags)

#define ulong            unsigned long
#define UNSIGNED         0
#define SIGNED           1

/****************************************************************************/
static void                  /* returns nothing                             */
    _rbputl(                 /* output integral number to record stream     */
        REC *rp,             /* pointer to record stream                    */
        int  base,           /* base (radix) (2 to 36)                      */
        int  sign,           /* signed number (1=signed; 0=unsigned)        */
        long num)            /* number to put to stream                     */
/****************************************************************************/
{
    if (!_rstatus(rp, R_WRITE)) { 
        if (base >= 2 && base <= 36) { 
            rfldno(rp)++;
            rflags(rp) &= ~_R_TXT;

            /* if not first field, put field separator */
            if (rfldno(rp) > 1) { 
                if (_rputc(rp, rfldch(rp))) goto done; 
            }

            /* based on sign, select conversion function */
            if (sign) {
                ltoa(num, _r_nsbuf, base);
            } else {
                ultoa((ulong)num, _r_nsbuf, base);
            }

            /* output converted string */
            if (fputs(_r_nsbuf, rfp(rp)) != EOF) {
                rcol(rp) += strlen(_r_nsbuf); 
            } else { 
                rseterr(rp, R_ENOPUT); 
            } 

        } else {
            rseterr(rp, R_EINVAL);
        }
    } 
done:
}

/****************************************************************************/
/* character delimited integral number output functions                     */
/****************************************************************************/
void rbputi(REC *rp, int base, int num)
{
    _rbputl(rp, base, SIGNED, (long) num);
}

void rbputui(REC *rp, int base, unsigned int num)
{
    _rbputl(rp, base, UNSIGNED, (long) num);
}

void rbputl(REC *rp, int base, long num)
{
    _rbputl(rp, base, SIGNED, num);
}

void rbputul(REC *rp, int base, unsigned long num)
{
    _rbputl(rp, base, UNSIGNED, (long) num);
}
